/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.chests;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGUI;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;

@IocBukkitListener
public class ChestGuiMove
implements Listener {
    private final OnlineSessionsManager sessionManager;

    public ChestGuiMove(OnlineSessionsManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        PlayerSession playerSession = this.sessionManager.get(player);
        if (!playerSession.getCurrentGui().isPresent() || !(playerSession.getCurrentGui().get() instanceof ChestGUI)) {
            return;
        }
        ChestGUI chestGUI = (ChestGUI)playerSession.getCurrentGui().get();
        if (!chestGUI.isInteractionEnabled()) {
            event.setCancelled(true);
            return;
        }
        if (event.getClick() != ClickType.LEFT) {
            event.setCancelled(true);
            return;
        }
        if (!this.isEmptyStack(event.getCursor()) && !this.isEmptyStack(event.getCurrentItem())) {
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() != null && event.getClickedInventory().equals((Object)chestGUI.getInventory())) {
            this.handleChestInventoryClick(event, chestGUI);
        }
        if (event.getClickedInventory() != null && event.getClickedInventory().equals((Object)player.getInventory())) {
            this.handleStaffInventoryClick(event, chestGUI);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        PlayerSession playerSession = this.sessionManager.get(player);
        if (!playerSession.getCurrentGui().isPresent() || !(playerSession.getCurrentGui().get() instanceof ChestGUI)) {
            return;
        }
        ChestGUI chestGUI = (ChestGUI)playerSession.getCurrentGui().get();
        if (!chestGUI.isInteractionEnabled()) {
            return;
        }
        if (!this.isEmptyStack(player.getItemOnCursor()) && "player".equalsIgnoreCase(chestGUI.getItemSelectedFrom())) {
            player.setItemOnCursor(null);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void dragItem(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        PlayerSession playerSession = this.sessionManager.get(player);
        if (!playerSession.getCurrentGui().isPresent() || !(playerSession.getCurrentGui().get() instanceof ChestGUI)) {
            return;
        }
        event.setCancelled(true);
    }

    private void handleChestInventoryClick(InventoryClickEvent event, ChestGUI chestGUI) {
        if (!this.isEmptyStack(event.getCursor()) && this.isEmptyStack(event.getCurrentItem()) && "staff".equalsIgnoreCase(chestGUI.getItemSelectedFrom())) {
            chestGUI.getTargetInventory().setItem(event.getSlot(), event.getCursor());
        }
        chestGUI.setItemSelectedFrom(null);
        if (this.isEmptyStack(event.getCursor()) && !this.isEmptyStack(event.getCurrentItem())) {
            chestGUI.setItemSelectedFrom("player");
            chestGUI.setItemSelectedSlot(event.getSlot());
        }
    }

    private void handleStaffInventoryClick(InventoryClickEvent event, ChestGUI chestGUI) {
        if (!this.isEmptyStack(event.getCursor()) && this.isEmptyStack(event.getCurrentItem()) && "player".equalsIgnoreCase(chestGUI.getItemSelectedFrom())) {
            chestGUI.getTargetInventory().setItem(chestGUI.getItemSelectedSlot(), null);
        }
        chestGUI.setItemSelectedFrom(null);
        if (this.isEmptyStack(event.getCursor()) && !this.isEmptyStack(event.getCurrentItem())) {
            chestGUI.setItemSelectedFrom("staff");
        }
    }

    private boolean isEmptyStack(ItemStack cursor) {
        return cursor == null || cursor.getType() == Material.AIR;
    }
}

