/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.broadcast;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.bungee.BungeeAction;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.common.bungee.BungeeContext;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.staff.broadcast.config.BroadcastConfiguration;
import org.bukkit.command.CommandSender;

@IocBean
public class BroadcastService {
    private final Messages messages;
    private final BroadcastConfiguration broadcastConfiguration;
    private final BungeeClient bungeeClient;

    public BroadcastService(Messages messages, BroadcastConfiguration broadcastConfiguration, BungeeClient bungeeClient) {
        this.messages = messages;
        this.broadcastConfiguration = broadcastConfiguration;
        this.bungeeClient = bungeeClient;
    }

    void handleBungeeBroadcast(String message) {
        this.broadcast(message);
    }

    public void broadcastToCurrent(String message) {
        if (this.broadcastConfiguration.multipleServers()) {
            throw new BusinessException("&CNot allowed to use server [current] when configuration contains a list of network servers. Please specify the server name instead of [current].");
        }
        this.broadcast(message);
    }

    public void broadcastToAll(CommandSender sender, String message) {
        List<String> networkServers = this.broadcastConfiguration.getEnabledServers();
        if (this.broadcastConfiguration.sendToCurrent()) {
            this.broadcast(message);
        } else if (this.broadcastConfiguration.sendToAll()) {
            this.broadcast(message);
            this.bungeeClient.sendAll(sender, BungeeAction.FORWARD, BungeeContext.BROADCAST, message);
        } else {
            for (String networkServer : networkServers) {
                this.bungeeClient.send(sender, BungeeAction.FORWARD, networkServer, BungeeContext.BROADCAST, message);
            }
        }
    }

    public void broadcastToSpecific(CommandSender sender, List<String> servers, String message) {
        if (this.broadcastConfiguration.sendToCurrent()) {
            throw new BusinessException("&CConfiguration is set up to use current server. Cannot broadcast to another server");
        }
        List invalidServers = servers.stream().filter(s -> !this.broadcastConfiguration.getEnabledServers().contains(s)).collect(Collectors.toList());
        if (!invalidServers.isEmpty()) {
            throw new BusinessException("&CCannot use server names: [" + String.join((CharSequence)" - ", invalidServers) + "]");
        }
        for (String server : servers) {
            this.bungeeClient.send(sender, BungeeAction.FORWARD, server, BungeeContext.BROADCAST, message);
        }
    }

    private void broadcast(String message) {
        String[] lines;
        for (String line : lines = message.split(Pattern.quote("\\n"))) {
            this.messages.sendGlobalMessage(line, this.broadcastConfiguration.getPrefix());
        }
    }
}

