/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans.gui.cmd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanService;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanConfiguration;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;

@Command(command="commands:unban", permissions={"permissions:unban"}, description="Unban a player", usage="[player] [reason]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH, async=true)
@IocBean(conditionalOnProperty="ban-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class UnbanCmd
extends AbstractCmd {
    private final BanService banService;
    private final BanConfiguration banConfiguration;
    private final PlayerManager playerManager;
    private final PermissionHandler permissionHandler;

    public UnbanCmd(Messages messages, BanConfiguration banConfiguration, BanService banService, CommandService commandService, PlayerManager playerManager, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.banConfiguration = banConfiguration;
        this.playerManager = playerManager;
        this.banService = banService;
        this.permissionHandler = permissionHandler;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        boolean isSilent = Arrays.stream(args).anyMatch(a -> a.equalsIgnoreCase("-silent"));
        if (isSilent && !this.permissionHandler.has(sender, this.banConfiguration.permissionBanSilent)) {
            throw new NoPermissionException("You don't have the permission to execute a silent unban");
        }
        String[] argsWithoutParameters = (String[])Arrays.stream(args).filter(a -> !a.equalsIgnoreCase("-silent")).toArray(String[]::new);
        String reason = JavaUtils.compileWords(argsWithoutParameters, 1);
        this.banService.unban(sender, player, reason, isSilent);
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 2;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.ofNullable(args[0]);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        String[] finalArgs = (String[])Arrays.stream(args).filter(a -> !a.equalsIgnoreCase("-silent")).toArray(String[]::new);
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> finalArgs[0].isEmpty() || s.contains(finalArgs[0])).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

