/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans.gui;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.Ban;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanService;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.database.BansRepository;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class BanGuiController {
    private static final String CANCEL = "cancel";
    private static final int PAGE_SIZE = 45;
    private final Messages messages;
    private final BanService banService;
    private final BansRepository bansRepository;
    private final OnlineSessionsManager sessionManager;
    private final PlayerManager playerManager;

    public BanGuiController(Messages messages, BanService banService, BansRepository bansRepository, OnlineSessionsManager sessionManager, PlayerManager playerManager) {
        this.messages = messages;
        this.banService = banService;
        this.bansRepository = bansRepository;
        this.sessionManager = sessionManager;
        this.playerManager = playerManager;
    }

    @GuiAction(value="manage-bans/view/overview")
    public AsyncGui<GuiTemplate> getBannedPlayersOverview(@GuiParam(value="targetPlayerName") String targetPlayerName, @GuiParam(value="page", defaultValue="0") int page) {
        SppPlayer target = null;
        if (StringUtils.isNotBlank(targetPlayerName)) {
            target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
        }
        SppPlayer finalTarget = target;
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bans", this.getBans(finalTarget, page));
            return GuiTemplate.template("gui/bans/bans-overview.ftl", params);
        });
    }

    private List<Ban> getBans(SppPlayer target, int page) {
        if (target == null) {
            return this.banService.getAllPaged(page * 45, 45);
        }
        return this.bansRepository.getBansForPlayerPaged(target.getId(), page * 45, 45);
    }

    @GuiAction(value="manage-bans/view/detail")
    public AsyncGui<GuiTemplate> getBanDetailView(@GuiParam(value="banId") int banId) {
        return AsyncGui.async(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("ban", this.banService.getById(banId));
            return GuiTemplate.template("gui/bans/ban-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-bans/view/history")
    public AsyncGui<GuiTemplate> getBansPlayersHistory(@GuiParam(value="page", defaultValue="0") int page, @GuiParam(value="targetPlayerName") String targetPlayerName) {
        return AsyncGui.async(() -> {
            SppPlayer target = this.playerManager.getOnOrOfflinePlayer(targetPlayerName).orElseThrow(() -> new PlayerNotFoundException(targetPlayerName));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bans", this.bansRepository.getBansForPlayerPaged(target.getId(), page * 45, 45));
            params.put("target", target);
            return GuiTemplate.template("gui/bans/bans-history-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-bans/unban")
    public void unban(Player player, @GuiParam(value="banId") int banId) {
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         You have chosen to unban this player", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6Type your reason for unbanning this player in chat", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6        Type \"cancel\" to cancel the unban ", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        SppPlayer target = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        PlayerSession playerSession = this.sessionManager.get(player);
        playerSession.setChatAction((player1, message) -> {
            if (message.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, "&CYou have cancelled unbanning this player", this.messages.prefixBans);
                return;
            }
            this.banService.unban(target, banId, message);
        });
    }
}

