/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans.config;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.common.exceptions.DatabaseException;

@IocBean
public class BanTemplateLoader {
    private final TubingPlugin tubingPlugin;

    public BanTemplateLoader(@InjectTubingPlugin TubingPlugin tubingPlugin) {
        this.tubingPlugin = tubingPlugin;
    }

    public Map<String, String> loadTemplates() {
        String directoryPath = this.tubingPlugin.getDataFolder() + File.separator + "bans";
        File banDir = new File(directoryPath);
        if (!banDir.exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> templates = new HashMap<String, String>();
        for (File file : Objects.requireNonNull(banDir.listFiles())) {
            templates.put(this.getFileNameWithoutExtension(file), this.readTemplate(file));
        }
        return templates;
    }

    private String getFileNameWithoutExtension(File file) {
        return file.getName().substring(0, file.getName().lastIndexOf(46));
    }

    private String readTemplate(File filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(filePath.toPath(), StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
        return contentBuilder.toString();
    }
}

