/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigObjectList;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanGuiItemConfig;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanReasonConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanTemplateLoader;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;

@IocBean
public class BanConfiguration {
    @ConfigProperty(value="ban-module.enabled")
    public boolean enabled;
    @ConfigProperty(value="permissions:tempban")
    public String permissionTempbanPlayer;
    @ConfigProperty(value="permissions:extendban")
    public String permissionExtendBanPlayer;
    @ConfigProperty(value="permissions:reduceban")
    public String permissionReduceBanPlayer;
    @ConfigProperty(value="permissions:ban-bypass")
    public String permissionBanByPass;
    @ConfigProperty(value="permissions:ban-template-overwrite")
    public String permissionBanTemplateOverwrite;
    @ConfigProperty(value="permissions:ban-silent")
    public String permissionBanSilent;
    @ConfigProperty(value="permissions:ban-notifications")
    public String staffNotificationPermission;
    @ConfigProperty(value="ban-module.permban-template")
    public String permBanTemplate;
    @ConfigProperty(value="ban-module.tempban-template")
    public String tempBanTemplate;
    @ConfigProperty(value="ban-module.reasons")
    @ConfigObjectList(value=BanReasonConfiguration.class)
    public List<BanReasonConfiguration> banReasons = new ArrayList<BanReasonConfiguration>();
    public final Map<String, String> templates;
    public final BanGuiItemConfig banGuiItemConfig;

    public BanConfiguration(BanTemplateLoader banTemplateLoader, BanGuiItemConfig banGuiItemConfig) {
        this.templates = banTemplateLoader.loadTemplates();
        this.banGuiItemConfig = banGuiItemConfig;
    }

    public Optional<String> getDefaultBanTemplate(BanType banType) {
        if (banType == BanType.PERM_BAN) {
            return StringUtils.isEmpty(this.permBanTemplate) ? Optional.empty() : Optional.of(this.permBanTemplate);
        }
        return StringUtils.isEmpty(this.tempBanTemplate) ? Optional.empty() : Optional.of(this.tempBanTemplate);
    }

    public Optional<String> getTemplate(String template) {
        return Optional.ofNullable(this.templates.get(template));
    }

    public Optional<BanReasonConfiguration> getBanReason(String reason, BanType banType) {
        return this.getBanReasons(banType).stream().filter(b -> b.getName().equalsIgnoreCase(reason)).findFirst();
    }

    public List<BanReasonConfiguration> getBanReasons(BanType banType) {
        return this.banReasons.stream().filter(b -> !b.getBanType().isPresent() || b.getBanType().get() == banType).collect(Collectors.toList());
    }
}

