/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans.bungee.dto;

import java.util.UUID;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.bungee.BungeeMessage;
import net.shortninja.staffplusplus.ban.IBan;

public class BanBungeeDto
extends BungeeMessage {
    private final int id;
    private final String reason;
    private final String targetName;
    private final UUID targetUuid;
    private final String issuerName;
    private final UUID issuerUuid;
    private final String unbannedByName;
    private final UUID unbannedByUuid;
    private final String unbanReason;
    private final boolean silentBan;
    private final boolean silentUnban;
    private final Long endTimestamp;
    private String banMessage;

    public BanBungeeDto(IBan ban, String banMessage) {
        super(ban.getServerName());
        this.id = ban.getId();
        this.reason = ban.getReason();
        this.targetName = ban.getTargetName();
        this.targetUuid = ban.getTargetUuid();
        this.issuerName = ban.getIssuerName();
        this.issuerUuid = ban.getIssuerUuid();
        this.unbannedByName = ban.getUnbannedByName();
        this.unbannedByUuid = ban.getUnbannedByUuid();
        this.unbanReason = ban.getUnbanReason();
        this.silentBan = ban.isSilentBan();
        this.silentUnban = ban.isSilentUnban();
        this.banMessage = banMessage;
        this.endTimestamp = ban.getEndTimestamp();
    }

    public BanBungeeDto(IBan ban) {
        super(ban.getServerName());
        this.id = ban.getId();
        this.reason = ban.getReason();
        this.targetName = ban.getTargetName();
        this.targetUuid = ban.getTargetUuid();
        this.issuerName = ban.getIssuerName();
        this.issuerUuid = ban.getIssuerUuid();
        this.unbannedByName = ban.getUnbannedByName();
        this.unbannedByUuid = ban.getUnbannedByUuid();
        this.unbanReason = ban.getUnbanReason();
        this.silentBan = ban.isSilentBan();
        this.silentUnban = ban.isSilentUnban();
        this.endTimestamp = ban.getEndTimestamp();
    }

    public int getId() {
        return this.id;
    }

    public String getReason() {
        return this.reason;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public UUID getTargetUuid() {
        return this.targetUuid;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public UUID getIssuerUuid() {
        return this.issuerUuid;
    }

    public String getUnbannedByName() {
        return this.unbannedByName;
    }

    public UUID getUnbannedByUuid() {
        return this.unbannedByUuid;
    }

    public String getUnbanReason() {
        return this.unbanReason;
    }

    public boolean isSilentBan() {
        return this.silentBan;
    }

    public boolean isSilentUnban() {
        return this.silentUnban;
    }

    public String getBanMessage() {
        return this.banMessage;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public String getHumanReadableDuration() {
        if (this.endTimestamp == null) {
            return null;
        }
        long duration = JavaUtils.getDuration(this.endTimestamp);
        return JavaUtils.toHumanReadableDuration(duration);
    }
}

