/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans;

import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import org.bukkit.OfflinePlayer;

public class PlayerRanks {
    private final List<String> ranks;
    private final PermissionHandler permission;

    public PlayerRanks(List<String> ranks, PermissionHandler permission) {
        this.ranks = ranks;
        this.permission = permission;
    }

    public boolean hasHigherRank(OfflinePlayer player1, OfflinePlayer player2) {
        Optional<String> player1Rank = this.getPlayerRank(player1);
        Optional<String> player2Rank = this.getPlayerRank(player2);
        if (player1Rank.isPresent() && player2Rank.isPresent()) {
            return this.ranks.indexOf(player1Rank.get()) > this.ranks.indexOf(player2Rank.get());
        }
        return player1Rank.isPresent() || !player2Rank.isPresent();
    }

    private Optional<String> getPlayerRank(OfflinePlayer player) {
        for (int i = this.ranks.size() - 1; i >= 0; --i) {
            if (!this.permission.has(player, this.ranks.get(i))) continue;
            return Optional.ofNullable(this.ranks.get(i));
        }
        return Optional.empty();
    }

    public boolean isEmpty() {
        return this.ranks.isEmpty();
    }
}

