/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanReasonConfiguration;

@IocBean
public class BanTemplateResolver {
    private final BanConfiguration banConfiguration;
    private final Messages messages;

    public BanTemplateResolver(BanConfiguration banConfiguration, Messages messages) {
        this.banConfiguration = banConfiguration;
        this.messages = messages;
    }

    public String resolveTemplate(String reason, String providedTemplate, BanType banType) {
        Optional<String> templateName = this.getTemplateName(reason, providedTemplate, banType);
        if (templateName.isPresent()) {
            return this.getTemplate(templateName.get());
        }
        return banType == BanType.PERM_BAN ? this.messages.permanentBannedKick : this.messages.tempBannedKick;
    }

    public Optional<String> getTemplateName(String reason, String providedTemplate, BanType banType) {
        if (providedTemplate != null) {
            return Optional.of(providedTemplate);
        }
        Optional<BanReasonConfiguration> banReasonConfig = this.banConfiguration.getBanReason(reason, banType);
        if (banReasonConfig.isPresent() && banReasonConfig.get().getTemplate().isPresent()) {
            return Optional.of(banReasonConfig.get().getTemplate().get());
        }
        return this.banConfiguration.getDefaultBanTemplate(banType);
    }

    public boolean hasTemplate(String providedTemplate) {
        return this.banConfiguration.getTemplate(providedTemplate).isPresent();
    }

    private String getTemplate(String providedTemplate) {
        return this.banConfiguration.getTemplate(providedTemplate).orElseThrow(() -> new BusinessException("&CCannot find ban template with name [" + providedTemplate + "]"));
    }
}

