/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.Ban;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanMessageStringUtil;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanReasonResolver;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanTemplateResolver;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.PlayerRanks;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.database.BansRepository;
import net.shortninja.staffplus.core.domain.staff.infractions.Infraction;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionInfo;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionProvider;
import net.shortninja.staffplus.core.domain.staff.infractions.InfractionType;
import net.shortninja.staffplus.core.domain.staff.infractions.config.InfractionsConfiguration;
import net.shortninja.staffplusplus.ban.BanEvent;
import net.shortninja.staffplusplus.ban.BanExtensionEvent;
import net.shortninja.staffplusplus.ban.BanFilters;
import net.shortninja.staffplusplus.ban.BanReductionEvent;
import net.shortninja.staffplusplus.ban.UnbanEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={InfractionProvider.class})
public class BanService
implements InfractionProvider,
net.shortninja.staffplusplus.ban.BanService {
    private static final String LIMIT = ".limit";
    private final PermissionHandler permission;
    private final BansRepository bansRepository;
    private final BanConfiguration banConfiguration;
    private final BanReasonResolver banReasonResolver;
    private final BanTemplateResolver banTemplateResolver;
    private final InfractionsConfiguration infractionsConfiguration;
    private final PlayerRanks playerRanks;

    public BanService(PermissionHandler permission, BansRepository bansRepository, BanConfiguration banConfiguration, BanReasonResolver banReasonResolver, BanTemplateResolver banTemplateResolver, InfractionsConfiguration infractionsConfiguration, @ConfigProperty(value="ban-module.ranks") List<String> ranks) {
        this.permission = permission;
        this.bansRepository = bansRepository;
        this.banConfiguration = banConfiguration;
        this.banReasonResolver = banReasonResolver;
        this.banTemplateResolver = banTemplateResolver;
        this.infractionsConfiguration = infractionsConfiguration;
        this.playerRanks = new PlayerRanks(ranks, permission);
    }

    @Override
    public void permBan(CommandSender issuer, SppPlayer playerToBan, String reason, String template, boolean isSilent) {
        this.ban(issuer, playerToBan, reason, template, null, BanType.PERM_BAN, isSilent);
    }

    @Override
    public void permBan(CommandSender issuer, SppPlayer playerToBan, String reason, boolean isSilent) {
        this.ban(issuer, playerToBan, reason, null, null, BanType.PERM_BAN, isSilent);
    }

    @Override
    public void tempBan(CommandSender issuer, SppPlayer playerToBan, Long durationInMillis, String reason, String template, boolean isSilent) {
        this.permission.validateDuration(issuer, this.banConfiguration.permissionTempbanPlayer + LIMIT, durationInMillis);
        this.ban(issuer, playerToBan, reason, template, durationInMillis, BanType.TEMP_BAN, isSilent);
    }

    @Override
    public void tempBan(CommandSender issuer, SppPlayer playerToBan, Long durationInMillis, String reason, boolean isSilent) {
        this.permission.validateDuration(issuer, this.banConfiguration.permissionTempbanPlayer + LIMIT, durationInMillis);
        this.ban(issuer, playerToBan, reason, null, durationInMillis, BanType.TEMP_BAN, isSilent);
    }

    @Override
    public void extendBan(CommandSender sender, SppPlayer player, long duration) {
        Ban ban = this.getBanByBannedUuid(player.getId()).orElseThrow(() -> new BusinessException("&CThis player isn't banned"));
        if (ban.getEndDate() == null) {
            throw new BusinessException("The player is permanently banned. Cannot extend ban");
        }
        long newDuration = ban.getEndTimestamp() - System.currentTimeMillis() + duration;
        this.permission.validateDuration(sender, this.banConfiguration.permissionTempbanPlayer + LIMIT, newDuration);
        this.permission.validateDuration(sender, this.banConfiguration.permissionExtendBanPlayer + LIMIT, duration);
        this.bansRepository.setBanDuration(ban.getId(), ban.getEndTimestamp() + duration);
        Ban updatedBan = this.getActiveById(ban.getId());
        BukkitUtils.sendEvent(new BanExtensionEvent(updatedBan, duration, sender));
    }

    @Override
    public void reduceBan(CommandSender sender, SppPlayer player, long duration) {
        Ban ban = this.getBanByBannedUuid(player.getId()).orElseThrow(() -> new BusinessException("&CThis player isn't banned"));
        if (ban.getEndDate() == null) {
            throw new BusinessException("The player is permanently banned. Cannot reduce ban");
        }
        this.permission.validateDuration(sender, this.banConfiguration.permissionReduceBanPlayer + LIMIT, duration);
        this.bansRepository.setBanDuration(ban.getId(), ban.getEndTimestamp() - duration);
        Ban updatedBan = this.getActiveById(ban.getId());
        BukkitUtils.sendEvent(new BanReductionEvent(updatedBan, duration, sender));
    }

    public Optional<Ban> getBanByBannedUuid(UUID playerUuid) {
        return this.bansRepository.findActiveBan(playerUuid);
    }

    @Override
    public Ban getActiveById(int banId) {
        return this.bansRepository.findActiveBan(banId).orElseThrow(() -> new BusinessException("&CNo ban found with this id"));
    }

    @Override
    public Ban getById(int banId) {
        return this.bansRepository.getBan(banId).orElseThrow(() -> new BusinessException("&CNo ban found with this id"));
    }

    public List<Ban> getAllPaged(int offset, int amount) {
        return this.bansRepository.getActiveBans(offset, amount);
    }

    @Override
    public void unban(CommandSender issuer, SppPlayer playerToUnban, String reason, boolean isSilent) {
        if (!this.canBanRank(issuer, playerToUnban)) {
            throw new BusinessException("&CYou don't have permission to unban this player!");
        }
        Ban ban = this.bansRepository.findActiveBan(playerToUnban.getId()).orElseThrow(() -> new BusinessException("&CCannot unban, this user is not banned"));
        ban.setUnbannedByName(issuer instanceof Player ? issuer.getName() : "Console");
        ban.setUnbannedByUuid(issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID);
        ban.setUnbanReason(reason);
        ban.setSilentUnban(isSilent);
        this.unban(ban);
    }

    @Override
    public void unban(SppPlayer issuer, int banId, String reason) {
        Ban ban = this.bansRepository.findActiveBan(banId).orElseThrow(() -> new BusinessException("&CCannot unban, this user is not banned"));
        ban.setUnbannedByName(issuer.getUsername());
        ban.setUnbannedByUuid(issuer.getId());
        ban.setUnbanReason(reason);
        this.unban(ban);
    }

    private void ban(CommandSender issuer, SppPlayer playerToBan, String reason, String providedTemplateName, Long durationInMillis, BanType banType, boolean isSilent) {
        if (providedTemplateName != null) {
            this.permission.validate(issuer, this.banConfiguration.permissionBanTemplateOverwrite);
        }
        if (playerToBan.isOnline() && this.permission.has(playerToBan.getPlayer(), this.banConfiguration.permissionBanByPass)) {
            throw new BusinessException("&CThis player bypasses being banned");
        }
        if (!this.canBanRank(issuer, playerToBan)) {
            throw new BusinessException("&CYou don't have permission to ban this player!");
        }
        this.bansRepository.findActiveBan(playerToBan.getId()).ifPresent(ban -> {
            throw new BusinessException("&CCannot ban this player, the player is already banned");
        });
        String fullReason = this.banReasonResolver.resolveBanReason(reason, banType);
        String templateMessage = this.banTemplateResolver.resolveTemplate(reason, providedTemplateName, banType);
        String templateName = this.banTemplateResolver.getTemplateName(reason, providedTemplateName, banType).orElse(null);
        String issuerName = issuer instanceof Player ? issuer.getName() : "Console";
        UUID issuerUuid = issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID;
        Long endDate = durationInMillis == null ? null : Long.valueOf(System.currentTimeMillis() + durationInMillis);
        Ban ban2 = new Ban(fullReason, endDate, issuerName, issuerUuid, playerToBan.getUsername(), playerToBan.getId(), isSilent, templateName);
        ban2.setId(this.bansRepository.addBan(ban2));
        String banMessage = BanMessageStringUtil.replaceBanPlaceholders(templateMessage, ban2);
        if (endDate == null || endDate > System.currentTimeMillis()) {
            BukkitUtils.sendEvent(new BanEvent(ban2, banMessage));
        }
    }

    private void unban(Ban ban) {
        this.bansRepository.update(ban);
        BukkitUtils.sendEvent(new UnbanEvent(ban));
    }

    public List<Ban> getAppealedBans(int offset, int amount) {
        return this.bansRepository.getAppealedBans(offset, amount);
    }

    @Override
    public List<? extends Infraction> getInfractions(Player executor, UUID playerUUID) {
        if (!this.infractionsConfiguration.isShowBans()) {
            return Collections.emptyList();
        }
        return this.bansRepository.getBansForPlayer(playerUUID);
    }

    @Override
    public Optional<InfractionInfo> getInfractionsInfo() {
        if (!this.infractionsConfiguration.isShowBans()) {
            return Optional.empty();
        }
        Map<UUID, List<String>> banDurationByPlayer = this.bansRepository.getBanDurationByPlayer().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.asList("&bTotal time banned: ", "&6" + JavaUtils.toHumanReadableDuration((Long)e.getValue()))));
        for (UUID permBannedPlayer : this.bansRepository.getAllPermanentBannedPlayers()) {
            banDurationByPlayer.put(permBannedPlayer, Collections.singletonList("&CPermanently banned"));
        }
        return Optional.of(new InfractionInfo(InfractionType.BAN, this.bansRepository.getCountByPlayer(), banDurationByPlayer));
    }

    @Override
    public InfractionType getType() {
        return InfractionType.BAN;
    }

    @Override
    public long getTotalBanCount() {
        return this.bansRepository.getTotalCount();
    }

    @Override
    public long getActiveBanCount() {
        return this.bansRepository.getActiveCount();
    }

    @Override
    public long getBanCount(BanFilters banFilters) {
        return this.bansRepository.getBanCount(banFilters);
    }

    private boolean canBanRank(CommandSender issuer, SppPlayer bannedPlayer) {
        if (this.playerRanks.isEmpty() || issuer instanceof ConsoleCommandSender) {
            return true;
        }
        return this.playerRanks.hasHigherRank((OfflinePlayer)((Player)issuer), bannedPlayer.getOfflinePlayer());
    }
}

