/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.playerbans;

import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.PlaceholderService;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.Ban;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanMessageStringUtil;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanService;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanTemplateResolver;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.bungee.dto.BanBungeeDto;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.bungee.events.BanBungeeEvent;
import net.shortninja.staffplusplus.ban.BanEvent;
import net.shortninja.staffplusplus.ban.IBan;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

@IocBukkitListener
public class BanKickListener
implements Listener {
    private final Messages messages;
    private final PlayerManager playerManager;
    private final BanService banService;
    private final BanTemplateResolver banTemplateResolver;
    private final PlaceholderService placeholderService;

    public BanKickListener(Messages messages, PlayerManager playerManager, BanService banService, BanTemplateResolver banTemplateResolver, PlaceholderService placeholderService) {
        this.messages = messages;
        this.playerManager = playerManager;
        this.banService = banService;
        this.banTemplateResolver = banTemplateResolver;
        this.placeholderService = placeholderService;
    }

    @EventHandler
    public void kickBannedPlayer(BanEvent banEvent) {
        this.playerManager.getOnlinePlayer(banEvent.getBan().getTargetUuid()).ifPresent(p -> {
            if (p.isOnline()) {
                String banMessage = this.getBanMessage(banEvent.getBan().getTargetUuid(), banEvent.getBan(), banEvent.getBanMessage());
                p.getPlayer().kickPlayer(this.messages.colorize(banMessage));
            }
        });
    }

    @EventHandler
    public void kickBannedPlayerBungee(BanBungeeEvent banEvent) {
        this.playerManager.getOnlinePlayer(banEvent.getBan().getTargetUuid()).ifPresent(p -> {
            if (p.isOnline()) {
                String banMessage = this.getBanMessage(banEvent.getBan().getTargetUuid(), banEvent.getBan(), banEvent.getBan().getBanMessage());
                p.getPlayer().kickPlayer(this.messages.colorize(banMessage));
            }
        });
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(AsyncPlayerPreLoginEvent event) {
        Optional<Ban> optionalBan = this.banService.getBanByBannedUuid(event.getUniqueId());
        if (optionalBan.isPresent()) {
            Ban ban = optionalBan.get();
            BanType banType = ban.getEndTimestamp() == null ? BanType.PERM_BAN : BanType.TEMP_BAN;
            String templateMessage = ban.getTemplate().isPresent() && this.banTemplateResolver.hasTemplate(ban.getTemplate().get()) ? this.banTemplateResolver.resolveTemplate(ban.getReason(), ban.getTemplate().get(), banType) : this.banTemplateResolver.resolveTemplate(ban.getReason(), null, banType);
            String banMessage = this.getBanMessage(event.getUniqueId(), ban, templateMessage);
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.messages.colorize(banMessage));
        }
    }

    private String getBanMessage(UUID playerUuid, IBan ban, String templateMessage) {
        Optional<SppPlayer> player = this.playerManager.getOnOrOfflinePlayer(playerUuid);
        return player.isPresent() ? this.placeholderService.setPlaceholders(player.get().getOfflinePlayer(), BanMessageStringUtil.replaceBanPlaceholders(templateMessage, ban)) : BanMessageStringUtil.replaceBanPlaceholders(templateMessage, ban);
    }

    private String getBanMessage(UUID playerUuid, BanBungeeDto ban, String templateMessage) {
        Optional<SppPlayer> player = this.playerManager.getOnOrOfflinePlayer(playerUuid);
        return player.isPresent() ? this.placeholderService.setPlaceholders(player.get().getOfflinePlayer(), BanMessageStringUtil.replaceBanPlaceholders(templateMessage, ban)) : BanMessageStringUtil.replaceBanPlaceholders(templateMessage, ban);
    }
}

