/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans.gui.cmd;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBan;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.database.IpBanRepository;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

@Command(command="commands:ipban.migrate", permissions={"permissions:ipban.migrate"}, description="Migrates default ip bans to staff++ ip bans", playerRetrievalStrategy=PlayerRetrievalStrategy.NONE)
@IocBean(conditionalOnProperty="ban-module.enabled=true && ban-module.ipban.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class MigrateIpBansCmd
extends AbstractCmd {
    private final BukkitUtils bukkitUtils;
    private final IpBanRepository bansRepository;
    private final Options options;

    public MigrateIpBansCmd(PermissionHandler permissionHandler, Messages messages, BukkitUtils bukkitUtils, CommandService commandService, IpBanRepository bansRepository, Options options) {
        super(messages, permissionHandler, commandService);
        this.bukkitUtils = bukkitUtils;
        this.bansRepository = bansRepository;
        this.options = options;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.IP);
        Set banEntries = banList.getBanEntries();
        this.bukkitUtils.runTaskAsync(sender, () -> {
            AtomicInteger count = new AtomicInteger();
            for (BanEntry banEntry : banEntries) {
                Long endDate = banEntry.getExpiration() == null ? null : Long.valueOf(banEntry.getExpiration().getTime());
                IpBan ban = new IpBan(banEntry.getTarget(), banEntry.getCreated().getTime(), endDate, "Console", Constants.CONSOLE_UUID, this.options.serverName, false, null);
                this.bansRepository.saveBan(ban);
                count.getAndIncrement();
            }
            this.bukkitUtils.runTaskLater(() -> {
                for (BanEntry banEntry : banEntries) {
                    banList.pardon(banEntry.getTarget());
                }
            });
            this.messages.send(sender, "&C" + count.get() + " &6Ip bans have been migrated", this.messages.prefixBans);
        });
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 0;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }
}

