/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans.gui.cmd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.PlayerRetrievalStrategy;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.ip.database.PlayerIpRepository;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBan;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;

@Command(command="commands:ipban.bancheck", permissions={"permissions:ipban.ban-check"}, description="Check if a player is ip banned", usage="[player]", playerRetrievalStrategy=PlayerRetrievalStrategy.BOTH)
@IocBean(conditionalOnProperty="ban-module.enabled=true && ban-module.ipban.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class IpBanCheckCmd
extends AbstractCmd {
    private final IpBanService banService;
    private final PlayerManager playerManager;
    private final PlayerIpRepository playerIpRepository;

    public IpBanCheckCmd(Messages messages, IpBanService banService, CommandService commandService, PlayerManager playerManager, PlayerIpRepository playerIpRepository, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.banService = banService;
        this.playerManager = playerManager;
        this.playerIpRepository = playerIpRepository;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        List matchingIpBans;
        Optional<String> ipAddress = this.getIpAddress(player);
        List<Object> list = matchingIpBans = ipAddress.isPresent() ? this.banService.findMatchingIpBans(ipAddress.get()) : Collections.emptyList();
        if (matchingIpBans.isEmpty()) {
            this.messages.send(sender, "&6This player is &2not ip banned.", this.messages.prefixBans);
        } else {
            this.messages.send(sender, "&6This player is &cip banned &6by following rules: ", this.messages.prefixBans);
            this.messages.send(sender, this.messages.LONG_LINE, this.messages.prefixBans);
            int matchingIpBansSize = matchingIpBans.size();
            for (int i = 0; i < matchingIpBansSize; ++i) {
                IpBan matchingIpBan = (IpBan)matchingIpBans.get(i);
                this.messages.send(sender, "&c" + (i + 1) + ". &7" + matchingIpBan.getIp(), this.messages.prefixBans);
            }
        }
        return true;
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        return 1;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.ofNullable(args[0]);
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args, String[] sppArgs) throws IllegalArgumentException {
        String currentArg;
        String string = currentArg = args.length > 0 ? args[args.length - 1] : "";
        if (args.length == 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> currentArg.isEmpty() || s.contains(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Optional<String> getIpAddress(SppPlayer sppPlayer) {
        return sppPlayer.isOnline() ? Optional.of(BukkitUtils.getIpFromPlayer(sppPlayer.getPlayer())) : this.playerIpRepository.getLastIp(sppPlayer.getId());
    }
}

