/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionBuilder;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.domain.player.ip.PlayerIpRecord;
import net.shortninja.staffplus.core.domain.player.ip.PlayerIpService;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanService;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@GuiController
public class IpBanGuiController {
    private final IpBanService banService;
    private final PlayerIpService playerIpService;

    public IpBanGuiController(IpBanService banService, PlayerIpService playerIpService) {
        this.banService = banService;
        this.playerIpService = playerIpService;
    }

    @GuiAction(value="ipbans/ban/confirm")
    public GuiTemplate showBanConfirmationGui(@GuiParam(value="ipAddress") String ipAddress, @GuiParam(value="templateName") String templateName, @GuiParam(value="silent", defaultValue="false") boolean silent) {
        String confirmAction = GuiActionBuilder.builder().action("ipbans/ban").param("ipAddress", ipAddress).param("templateName", templateName).param("silent", String.valueOf(silent)).build();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("confirmationMessageLines", this.buildConfirmationMessage(ipAddress));
        params.put("title", "Ban IP?");
        params.put("confirmAction", confirmAction);
        params.put("cancelAction", "$BACK");
        return GuiTemplate.template("gui/commons/confirmation.ftl", params);
    }

    @GuiAction(value="ipbans/ban")
    public void ban(Player sender, @GuiParam(value="ipAddress") String ipAddress, @GuiParam(value="templateName") String templateName, @GuiParam(value="silent", defaultValue="false") boolean silent) {
        this.banService.banIp((CommandSender)sender, ipAddress, templateName, silent);
    }

    @GuiAction(value="ipbans/temp-ban/confirm")
    public GuiTemplate showTempBanConfirmationGui(@GuiParam(value="ipAddress") String ipAddress, @GuiParam(value="templateName") String templateName, @GuiParam(value="duration") long duration, @GuiParam(value="silent", defaultValue="false") boolean silent) {
        String confirmAction = GuiActionBuilder.builder().action("ipbans/temp-ban").param("ipAddress", ipAddress).param("templateName", templateName).param("duration", String.valueOf(duration)).param("silent", String.valueOf(silent)).build();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("confirmationMessageLines", this.buildConfirmationMessage(ipAddress));
        params.put("title", "Temp Ban IP?");
        params.put("confirmAction", confirmAction);
        params.put("cancelAction", "$BACK");
        return GuiTemplate.template("gui/commons/confirmation.ftl", params);
    }

    @NotNull
    private List<String> buildConfirmationMessage(@GuiParam(value="ipAddress") String ipAddress) {
        List<PlayerIpRecord> players = ipAddress.contains("/") ? this.playerIpService.getMatchedBySubnet(ipAddress) : this.playerIpService.getMatchedByIp(ipAddress);
        ArrayList<String> messageLines = new ArrayList<String>();
        messageLines.add("&6Following players are matching the current IP rule you will add.");
        for (int i = 0; i < players.size(); ++i) {
            PlayerIpRecord player = players.get(i);
            messageLines.add("&c" + (i + 1) + ". &7" + player.getPlayerName());
        }
        return messageLines;
    }

    @GuiAction(value="ipbans/temp-ban")
    public void tempBan(Player sender, @GuiParam(value="ipAddress") String ipAddress, @GuiParam(value="templateName") String templateName, @GuiParam(value="duration") long duration, @GuiParam(value="silent", defaultValue="false") boolean silent) {
        this.banService.tempBanIp((CommandSender)sender, ipAddress, templateName, duration, silent);
    }
}

