/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans.gui;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanMessageStringUtil;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.bungee.dto.IpBanBungeeDto;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.bungee.events.IpBanBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.bungee.events.IpUnbanBungeeEvent;
import net.shortninja.staffplusplus.ban.IIpBan;
import net.shortninja.staffplusplus.ban.IpBanEvent;
import net.shortninja.staffplusplus.ban.IpUnbanEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class IpBanChatNotifier
implements Listener {
    private final Messages messages;
    private final IpBanConfiguration banConfiguration;
    private final PlayerManager playerManager;

    public IpBanChatNotifier(Messages messages, IpBanConfiguration banConfiguration, PlayerManager playerManager) {
        this.messages = messages;
        this.banConfiguration = banConfiguration;
        this.playerManager = playerManager;
    }

    @EventHandler
    public void notifyIpBanned(IpBanEvent event) {
        IIpBan ban = event.getBan();
        this.playerManager.getOnlinePlayer(ban.getIssuerUuid()).ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), "&6Ban executed", this.messages.prefixBans));
        if (!ban.isSilentBan()) {
            String banMessage = !ban.getEndTimestamp().isPresent() ? this.messages.ipbanPermabanned : this.messages.ipbanTempbanned;
            String message = IpBanMessageStringUtil.replaceBanPlaceholders(banMessage, ban);
            this.messages.sendGroupMessage(message, this.banConfiguration.staffNotificationPermission, this.messages.prefixBans);
        }
    }

    @EventHandler
    public void notifyIpBannedBungee(IpBanBungeeEvent event) {
        IpBanBungeeDto ban = event.getBan();
        this.playerManager.getOnlinePlayer(ban.getIssuerUuid()).ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), "&6Ban executed", this.messages.prefixBans));
        if (!ban.isSilentBan()) {
            String banMessage = ban.getEndTimestamp() != null ? this.messages.ipbanPermabanned : this.messages.ipbanTempbanned;
            String message = IpBanMessageStringUtil.replaceBanPlaceholders(banMessage, ban);
            this.messages.sendGroupMessage(message, this.banConfiguration.staffNotificationPermission, this.messages.prefixBans);
        }
    }

    @EventHandler
    public void notifyUnban(IpUnbanEvent event) {
        IIpBan ban = event.getBan();
        this.playerManager.getOnlinePlayer(ban.getIssuerUuid()).ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), "&6Unban executed", this.messages.prefixBans));
        if (!ban.isSilentUnban()) {
            String unbanMessage = IpBanMessageStringUtil.replaceBanPlaceholders(this.messages.ipbanUnbanned, ban);
            this.messages.sendGroupMessage(unbanMessage, this.banConfiguration.staffNotificationPermission, this.messages.prefixBans);
        }
    }

    @EventHandler
    public void notifyIpUnbannedBungee(IpUnbanBungeeEvent event) {
        IpBanBungeeDto ban = event.getBan();
        this.playerManager.getOnlinePlayer(ban.getIssuerUuid()).ifPresent(p -> this.messages.send((CommandSender)p.getPlayer(), "&6Ban executed", this.messages.prefixBans));
        if (!ban.isSilentBan()) {
            String unbanMessage = IpBanMessageStringUtil.replaceBanPlaceholders(this.messages.ipbanUnbanned, ban);
            this.messages.sendGroupMessage(unbanMessage, this.banConfiguration.staffNotificationPermission, this.messages.prefixBans);
        }
    }
}

