/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans.bungee.dto;

import java.util.UUID;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.bungee.BungeeMessage;
import net.shortninja.staffplusplus.ban.IIpBan;

public class IpBanBungeeDto
extends BungeeMessage {
    private final Long id;
    private final String ip;
    private final String issuerName;
    private final UUID issuerUuid;
    private final String unbannedByName;
    private final UUID unbannedByUuid;
    private final boolean silentBan;
    private final boolean silentUnban;
    private final Long creationDate;
    private final Long endTimestamp;
    private final boolean isSubnet;
    private String template;

    public IpBanBungeeDto(IIpBan ban, String template) {
        super(ban.getServerName());
        this.id = ban.getId();
        this.ip = ban.getIp();
        this.issuerName = ban.getIssuerName();
        this.issuerUuid = ban.getIssuerUuid();
        this.unbannedByName = ban.getUnbannedByName().orElse(null);
        this.unbannedByUuid = ban.getUnbannedByUuid().orElse(null);
        this.silentBan = ban.isSilentBan();
        this.silentUnban = ban.isSilentUnban();
        this.creationDate = ban.getCreationDate();
        this.endTimestamp = ban.getEndTimestamp().orElse(null);
        this.isSubnet = ban.isSubnet();
        this.template = template;
    }

    public IpBanBungeeDto(IIpBan ban) {
        super(ban.getServerName());
        this.id = ban.getId();
        this.ip = ban.getIp();
        this.issuerName = ban.getIssuerName();
        this.issuerUuid = ban.getIssuerUuid();
        this.unbannedByName = ban.getUnbannedByName().orElse(null);
        this.unbannedByUuid = ban.getUnbannedByUuid().orElse(null);
        this.silentBan = ban.isSilentBan();
        this.silentUnban = ban.isSilentUnban();
        this.creationDate = ban.getCreationDate();
        this.endTimestamp = ban.getEndTimestamp().orElse(null);
        this.isSubnet = ban.isSubnet();
    }

    public Long getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public UUID getIssuerUuid() {
        return this.issuerUuid;
    }

    public String getUnbannedByName() {
        return this.unbannedByName;
    }

    public UUID getUnbannedByUuid() {
        return this.unbannedByUuid;
    }

    public boolean isSilentBan() {
        return this.silentBan;
    }

    public boolean isSilentUnban() {
        return this.silentUnban;
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public String getHumanReadableDuration() {
        if (this.endTimestamp == null) {
            return null;
        }
        long duration = JavaUtils.getDuration(this.endTimestamp);
        return JavaUtils.toHumanReadableDuration(duration);
    }

    public boolean isSubnet() {
        return this.isSubnet;
    }

    public String getTemplate() {
        return this.template;
    }
}

