/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans;

import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;

@IocBean
public class IpBanTemplateResolver {
    private final IpBanConfiguration banConfiguration;
    private final Messages messages;

    public IpBanTemplateResolver(IpBanConfiguration banConfiguration, Messages messages) {
        this.banConfiguration = banConfiguration;
        this.messages = messages;
    }

    public String resolveTemplate(String providedTemplate, BanType banType) {
        Optional<String> template = this.getTemplate(providedTemplate, banType);
        if (template.isPresent()) {
            return this.getTemplate(template.get());
        }
        return banType == BanType.PERM_BAN ? this.messages.ipbanPermabannedKick : this.messages.ipbanTempbannedKick;
    }

    public Optional<String> getTemplate(String providedTemplate, BanType banType) {
        if (providedTemplate != null) {
            return Optional.of(providedTemplate);
        }
        return this.banConfiguration.getDefaultBanTemplate(banType);
    }

    private String getTemplate(String providedTemplate) {
        return this.banConfiguration.getTemplate(providedTemplate).orElseThrow(() -> new BusinessException("&CCannot find ban template with name [" + providedTemplate + "]"));
    }

    public boolean hasTemplate(String s) {
        return this.banConfiguration.getTemplate(s).isPresent();
    }
}

