/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.common.Constants;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.ip.PlayerIpService;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBan;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanTemplateResolver;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.database.IpBanRepository;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.PlayerRanks;
import net.shortninja.staffplus.libs.org.apache.commons.net.util.SubnetUtils;
import net.shortninja.staffplusplus.ban.IpBanEvent;
import net.shortninja.staffplusplus.ban.IpUnbanEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

@IocBean
public class IpBanService {
    private final IpBanRepository ipBanRepository;
    private final Options options;
    private final Messages messages;
    private final IpBanTemplateResolver ipBanTemplateResolver;
    private final PlayerRanks playerRanks;
    private final PlayerIpService playerIpService;
    private final PlayerManager playerManager;

    public IpBanService(IpBanRepository ipBanRepository, Options options, Messages messages, IpBanTemplateResolver ipBanTemplateResolver, PermissionHandler permission, @ConfigProperty(value="ban-module.ranks") List<String> ranks, PlayerIpService playerIpService, PlayerManager playerManager) {
        this.ipBanRepository = ipBanRepository;
        this.options = options;
        this.messages = messages;
        this.ipBanTemplateResolver = ipBanTemplateResolver;
        this.playerIpService = playerIpService;
        this.playerManager = playerManager;
        this.playerRanks = new PlayerRanks(ranks, permission);
    }

    public void banIp(CommandSender issuer, String ipAddress, String template, boolean isSilent) {
        this.ban(issuer, ipAddress, template, null, isSilent);
    }

    public void tempBanIp(CommandSender issuer, String ipAddress, String template, Long durationInMillis, boolean isSilent) {
        this.ban(issuer, ipAddress, template, durationInMillis, isSilent);
    }

    private void ban(CommandSender issuer, String ipAddress, String template, Long durationInMillis, boolean isSilent) {
        List<IpBan> matchingIpBans = this.findMatchingIpBans(ipAddress);
        if (!matchingIpBans.isEmpty()) {
            throw new BusinessException("&cThis ip is already banned by the following rules: " + matchingIpBans.stream().map(IpBan::getIp).collect(Collectors.joining(" | ")), this.messages.prefixBans);
        }
        if (!this.canBanRank(issuer, ipAddress)) {
            throw new BusinessException("&CYou don't have permission to ban this ip!", this.messages.prefixBans);
        }
        String issuerName = issuer instanceof Player ? issuer.getName() : "Console";
        UUID issuerUuid = issuer instanceof Player ? ((Player)issuer).getUniqueId() : Constants.CONSOLE_UUID;
        Long endDate = durationInMillis == null ? null : Long.valueOf(System.currentTimeMillis() + durationInMillis);
        String templateName = this.ipBanTemplateResolver.getTemplate(template, endDate == null ? BanType.PERM_BAN : BanType.TEMP_BAN).orElse(null);
        IpBan ipBan = new IpBan(ipAddress, endDate, issuerName, issuerUuid, this.options.serverName, isSilent, templateName);
        ipBan.setId(this.ipBanRepository.saveBan(ipBan));
        BukkitUtils.sendEvent(new IpBanEvent(ipBan, template));
    }

    public List<IpBan> findMatchingIpBans(String ipAddress) {
        List<IpBan> bannedIps = this.ipBanRepository.getBannedIps();
        Optional<IpBan> first = bannedIps.stream().filter(b -> b.getIp().equalsIgnoreCase(ipAddress)).findFirst();
        if (first.isPresent()) {
            return Collections.singletonList(first.get());
        }
        if (this.isCidr(ipAddress)) {
            return Collections.emptyList();
        }
        return bannedIps.stream().filter(IpBan::isSubnet).filter(i -> new SubnetUtils(i.getIp()).getInfo().isInRange(ipAddress)).collect(Collectors.toList());
    }

    private boolean isCidr(String ipAddress) {
        return ipAddress.contains("/");
    }

    public void unbanIp(CommandSender sender, String ipAddress, boolean silent) {
        if (!this.canBanRank(sender, ipAddress)) {
            throw new BusinessException("&CYou don't have permission to unban this ip!", this.messages.prefixBans);
        }
        IpBan ipBan = this.ipBanRepository.getActiveBannedRule(ipAddress).orElseThrow(() -> new BusinessException("No ipban found with rule: " + ipAddress, this.messages.prefixBans));
        ipBan.setSilentUnban(silent);
        ipBan.setUnbannedByName(sender instanceof Player ? sender.getName() : "CONSOLE");
        ipBan.setUnbannedByUuid(sender instanceof Player ? ((Player)sender).getUniqueId() : Constants.CONSOLE_UUID);
        this.ipBanRepository.deleteBan(ipBan);
        BukkitUtils.sendEvent(new IpUnbanEvent(ipBan));
    }

    public List<IpBan> getAllActiveBans() {
        return this.ipBanRepository.getBannedIps();
    }

    private boolean canBanRank(CommandSender issuer, String ipAddress) {
        if (this.playerRanks.isEmpty()) {
            return true;
        }
        if (issuer instanceof ConsoleCommandSender) {
            return true;
        }
        return this.playerIpService.getPlayersMatchingIp(ipAddress).stream().map(r -> this.playerManager.getOnOrOfflinePlayer(r.getPlayerUuid())).filter(Optional::isPresent).map(Optional::get).allMatch(sppPlayer -> this.playerRanks.hasHigherRank((OfflinePlayer)((Player)issuer), sppPlayer.getOfflinePlayer()));
    }
}

