/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans;

import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBan;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanMessageStringUtil;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanService;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanTemplateResolver;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;

@IocBukkitListener
public class IpBanPreventJoinListener
implements Listener {
    private final IpBanService banService;
    private final Messages messages;
    private final IpBanTemplateResolver ipBanTemplateResolver;

    public IpBanPreventJoinListener(IpBanService banService, Messages messages, IpBanTemplateResolver ipBanTemplateResolver) {
        this.banService = banService;
        this.messages = messages;
        this.ipBanTemplateResolver = ipBanTemplateResolver;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJoin(AsyncPlayerPreLoginEvent event) {
        String ipAddress = event.getAddress().getHostAddress().replace("/", "");
        List<IpBan> ipBans = this.banService.findMatchingIpBans(ipAddress);
        if (!ipBans.isEmpty()) {
            IpBan ban = ipBans.get(0);
            BanType banType = !ban.getEndTimestamp().isPresent() ? BanType.PERM_BAN : BanType.TEMP_BAN;
            String templateMessage = ban.getTemplate().isPresent() && this.ipBanTemplateResolver.hasTemplate(ban.getTemplate().get()) ? this.ipBanTemplateResolver.resolveTemplate(ban.getTemplate().get(), banType) : this.ipBanTemplateResolver.resolveTemplate(null, banType);
            String banMessage = IpBanMessageStringUtil.replaceBanPlaceholders(templateMessage, ban);
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, this.messages.colorize(banMessage));
        }
    }
}

