/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.PlaceholderService;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.ip.PlayerIpRecord;
import net.shortninja.staffplus.core.domain.player.ip.PlayerIpService;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanMessageStringUtil;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.IpBanTemplateResolver;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.bungee.dto.IpBanBungeeDto;
import net.shortninja.staffplus.core.domain.staff.ban.ipbans.bungee.events.IpBanBungeeEvent;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplusplus.ban.IIpBan;
import net.shortninja.staffplusplus.ban.IpBanEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

@IocBukkitListener
public class IpBanKickPlayerListener
implements Listener {
    private final PlayerIpService playerIpService;
    private final PlayerManager playerManager;
    private final IpBanTemplateResolver ipBanTemplateResolver;
    private final Messages messages;
    private final PlaceholderService placeholderService;

    public IpBanKickPlayerListener(PlayerIpService playerIpService, PlayerManager playerManager, IpBanTemplateResolver ipBanTemplateResolver, Messages messages, PlaceholderService placeholderService) {
        this.playerIpService = playerIpService;
        this.playerManager = playerManager;
        this.ipBanTemplateResolver = ipBanTemplateResolver;
        this.messages = messages;
        this.placeholderService = placeholderService;
    }

    @EventHandler
    public void kickBannedPlayer(IpBanEvent ipBanEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            IIpBan ban = ipBanEvent.getBan();
            List<PlayerIpRecord> playersToKick = ban.isSubnet() ? this.playerIpService.getMatchedBySubnet(ban.getIp()) : this.playerIpService.getMatchedByIp(ban.getIp());
            Bukkit.getScheduler().runTaskLater((Plugin)StaffPlusPlus.get(), () -> {
                List<SppPlayer> sppPlayers = playersToKick.stream().map(p -> this.playerManager.getOnlinePlayer(p.getPlayerUuid())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                BanType banType = ban.getEndTimestamp().isPresent() ? BanType.TEMP_BAN : BanType.PERM_BAN;
                String template = this.ipBanTemplateResolver.resolveTemplate(ipBanEvent.getKickTemplate().orElse(null), banType);
                this.kickPlayers(sppPlayers, IpBanMessageStringUtil.replaceBanPlaceholders(template, ban));
            }, 1L);
        });
    }

    @EventHandler
    public void kickBannedPlayer(IpBanBungeeEvent ipBanEvent) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)StaffPlusPlus.get(), () -> {
            IpBanBungeeDto ban = ipBanEvent.getBan();
            List<PlayerIpRecord> playersToKick = ban.isSubnet() ? this.playerIpService.getMatchedBySubnet(ban.getIp()) : this.playerIpService.getMatchedByIp(ban.getIp());
            Bukkit.getScheduler().runTaskLater((Plugin)StaffPlusPlus.get(), () -> {
                List<SppPlayer> sppPlayers = playersToKick.stream().map(p -> this.playerManager.getOnlinePlayer(p.getPlayerUuid())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                BanType banType = ban.getEndTimestamp() != null ? BanType.TEMP_BAN : BanType.PERM_BAN;
                String template = this.ipBanTemplateResolver.resolveTemplate(ipBanEvent.getKickTemplate(), banType);
                this.kickPlayers(sppPlayers, IpBanMessageStringUtil.replaceBanPlaceholders(template, ban));
            }, 1L);
        });
    }

    private void kickPlayers(List<SppPlayer> sppPlayers, String s) {
        sppPlayers.forEach(sppPlayer -> {
            String banMessage = this.placeholderService.setPlaceholders(sppPlayer.getOfflinePlayer(), s);
            sppPlayer.getPlayer().kickPlayer(this.messages.colorize(banMessage));
        });
    }
}

