/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans;

import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanType;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.config.BanTemplateLoader;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;

@IocBean
public class IpBanConfiguration {
    @ConfigProperty(value="ban-module.ipban.enabled")
    public boolean enabled;
    @ConfigProperty(value="permissions:ipban.ban-silent")
    public String permissionBanSilent;
    @ConfigProperty(value="permissions:ipban.ban-template-overwrite")
    public String permissionBanTemplateOverwrite;
    @ConfigProperty(value="permissions:ipban.ban-notifications")
    public String staffNotificationPermission;
    @ConfigProperty(value="ban-module.ipban.permban-template")
    private String permBanTemplate;
    @ConfigProperty(value="ban-module.ipban.tempban-template")
    private String tempBanTemplate;
    private final Map<String, String> templates;

    public IpBanConfiguration(BanTemplateLoader banTemplateLoader) {
        this.templates = banTemplateLoader.loadTemplates();
    }

    public Optional<String> getDefaultBanTemplate(BanType banType) {
        if (banType == BanType.PERM_BAN) {
            return StringUtils.isEmpty(this.permBanTemplate) ? Optional.empty() : Optional.of(this.permBanTemplate);
        }
        return StringUtils.isEmpty(this.tempBanTemplate) ? Optional.empty() : Optional.of(this.tempBanTemplate);
    }

    public Optional<String> getTemplate(String template) {
        return Optional.ofNullable(this.templates.get(template));
    }
}

