/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.ipbans;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplusplus.ban.IIpBan;

public class IpBan
implements IIpBan {
    private Long id;
    private final String ip;
    private final String issuerName;
    private final UUID issuerUuid;
    private final boolean silentBan;
    private final Long creationDate;
    private final String serverName;
    private final String template;
    private String unbannedByName;
    private UUID unbannedByUuid;
    private boolean silentUnban;
    private Long endDate;

    public IpBan(Long id, String ip, String issuerName, UUID issuerUuid, String unbannedByName, UUID unbannedByUuid, boolean silentBan, boolean silentUnban, Long creationDate, Long endDate, String serverName, String template) {
        this.id = id;
        this.ip = ip;
        this.issuerName = issuerName;
        this.issuerUuid = issuerUuid;
        this.unbannedByName = unbannedByName;
        this.unbannedByUuid = unbannedByUuid;
        this.silentBan = silentBan;
        this.silentUnban = silentUnban;
        this.creationDate = creationDate;
        this.endDate = endDate;
        this.serverName = serverName;
        this.template = template;
    }

    public IpBan(String ip, Long endDate, String issuerName, UUID issuerUuid, String serverName, boolean silentBan, String template) {
        this.ip = ip;
        this.issuerName = issuerName;
        this.serverName = serverName;
        this.silentBan = silentBan;
        this.template = template;
        this.creationDate = System.currentTimeMillis();
        this.endDate = endDate;
        this.issuerUuid = issuerUuid;
    }

    public IpBan(String ip, long creationDate, Long endDate, String issuerName, UUID issuerUuid, String serverName, boolean silentBan, String template) {
        this.ip = ip;
        this.issuerName = issuerName;
        this.serverName = serverName;
        this.silentBan = silentBan;
        this.template = template;
        this.creationDate = creationDate;
        this.endDate = endDate;
        this.issuerUuid = issuerUuid;
    }

    public IpBan(String ip, String issuerName, UUID issuerUuid, String serverName, boolean silentBan, String template) {
        this.ip = ip;
        this.issuerName = issuerName;
        this.silentBan = silentBan;
        this.template = template;
        this.creationDate = System.currentTimeMillis();
        this.issuerUuid = issuerUuid;
        this.serverName = serverName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getIssuerName() {
        return this.issuerName;
    }

    @Override
    public UUID getIssuerUuid() {
        return this.issuerUuid;
    }

    @Override
    public Optional<String> getUnbannedByName() {
        return Optional.ofNullable(this.unbannedByName);
    }

    @Override
    public Optional<UUID> getUnbannedByUuid() {
        return Optional.ofNullable(this.unbannedByUuid);
    }

    public void setUnbannedByName(String unbannedByName) {
        this.unbannedByName = unbannedByName;
    }

    public void setUnbannedByUuid(UUID unbannedByUuid) {
        this.unbannedByUuid = unbannedByUuid;
    }

    @Override
    public boolean isSilentBan() {
        return this.silentBan;
    }

    @Override
    public boolean isSilentUnban() {
        return this.silentUnban;
    }

    @Override
    public Long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Optional<Long> getEndTimestamp() {
        return Optional.ofNullable(this.endDate);
    }

    @Override
    public Optional<ZonedDateTime> getEndDateTime() {
        if (this.endDate == null) {
            return Optional.empty();
        }
        return Optional.of(ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.endDate), ZoneId.systemDefault()));
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public boolean isSubnet() {
        return this.ip.contains("/");
    }

    public void setSilentUnban(boolean silentUnban) {
        this.silentUnban = silentUnban;
    }

    @Override
    public Optional<String> getTemplate() {
        return Optional.ofNullable(this.template);
    }

    @Override
    public String getHumanReadableDuration() {
        if (this.endDate == null) {
            return null;
        }
        long duration = JavaUtils.getDuration(this.endDate);
        return JavaUtils.toHumanReadableDuration(duration);
    }
}

