/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.appeals.gui;

import be.garagepoort.staffplusplus.craftbukkit.common.json.rayzr.JSONMessage;
import java.util.List;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.ban.appeals.BanAppealConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.Ban;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.database.BansRepository;
import net.shortninja.staffplusplus.appeals.AppealApprovedEvent;
import net.shortninja.staffplusplus.appeals.AppealRejectedEvent;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.appeals.AppealedEvent;
import net.shortninja.staffplusplus.appeals.IAppeal;
import net.shortninja.staffplusplus.ban.appeals.BanAppealApprovedEvent;
import net.shortninja.staffplusplus.ban.appeals.BanAppealRejectedEvent;
import net.shortninja.staffplusplus.ban.appeals.BanAppealedEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class BanAppealChatNotifier
implements Listener {
    @ConfigProperty(value="commands:bans.manage.gui")
    public List<String> commandManageBansGui;
    private final Messages messages;
    private final BanAppealConfiguration banAppealConfiguration;
    private final PlayerManager playerManager;
    private final BansRepository bansRepository;

    public BanAppealChatNotifier(Messages messages, BanAppealConfiguration banAppealConfiguration, PlayerManager playerManager, BansRepository bansRepository) {
        this.messages = messages;
        this.banAppealConfiguration = banAppealConfiguration;
        this.playerManager = playerManager;
        this.bansRepository = bansRepository;
    }

    @EventHandler
    public void handleAppealedEvent(AppealedEvent appealedEvent) {
        if (appealedEvent.getAppealable().getType() != AppealableType.BAN) {
            return;
        }
        Ban ban = (Ban)appealedEvent.getAppealable();
        ban.getAppeal().ifPresent(appeal -> {
            this.playerManager.getOnlinePlayer(appeal.getAppealerUuid()).ifPresent(appealer -> {
                this.sendAppealedMessageToStaff(ban, appealer.getPlayer());
                String message = this.messages.appealCreated.replace("%reason%", appeal.getReason());
                this.messages.send((CommandSender)appealer.getPlayer(), message, this.messages.prefixBans);
            });
            BukkitUtils.sendEvent(new BanAppealedEvent(ban));
        });
    }

    @EventHandler
    public void handleAppealApproved(AppealApprovedEvent appealApprovedEvent) {
        if (appealApprovedEvent.getAppeal().getType() != AppealableType.BAN) {
            return;
        }
        IAppeal appeal = appealApprovedEvent.getAppeal();
        Ban ban = this.bansRepository.getBan(appeal.getAppealableId()).orElseThrow(() -> new BusinessException("No ban found."));
        this.sendMessageToPlayer(appeal.getAppealerUuid(), this.messages.appealApproved);
        this.sendMessageToPlayer(appeal.getResolverUuid(), this.messages.appealApprove);
        BukkitUtils.sendEvent(new BanAppealApprovedEvent(appeal, ban));
    }

    @EventHandler
    public void handleAppealRejected(AppealRejectedEvent appealRejectedEvent) {
        if (appealRejectedEvent.getAppeal().getType() != AppealableType.BAN) {
            return;
        }
        IAppeal appeal = appealRejectedEvent.getAppeal();
        Ban ban = this.bansRepository.getBan(appeal.getAppealableId()).orElseThrow(() -> new BusinessException("No ban found."));
        this.sendMessageToPlayer(appeal.getAppealerUuid(), this.messages.appealRejected);
        this.sendMessageToPlayer(appeal.getResolverUuid(), this.messages.appealReject);
        BukkitUtils.sendEvent(new BanAppealRejectedEvent(appeal, ban));
    }

    private void sendMessageToPlayer(UUID appealerUuid, String appealApproved) {
        this.playerManager.getOnlinePlayer(appealerUuid).ifPresent(sppPlayer -> this.messages.send((CommandSender)sppPlayer.getPlayer(), appealApproved, this.messages.prefixBans));
    }

    private void sendAppealedMessageToStaff(Ban ban, Player appealer) {
        String manageBansCommand = this.commandManageBansGui.get(0) + " " + ban.getTargetName();
        JSONMessage jsonMessage = JavaUtils.buildClickableMessage(appealer.getName() + " has appealed a ban", "View bans!", "Click to open the bans view", manageBansCommand, true);
        this.messages.sendGroupMessage(jsonMessage, this.banAppealConfiguration.permissionNotifications);
    }
}

