/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.ban.appeals;

import java.util.HashMap;
import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.AsyncGui;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiAction;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiController;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiParam;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.templates.GuiTemplate;
import net.shortninja.staffplus.core.common.exceptions.PlayerNotFoundException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.common.utils.Validator;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.appeals.Appeal;
import net.shortninja.staffplus.core.domain.staff.appeals.AppealService;
import net.shortninja.staffplus.core.domain.staff.ban.appeals.BanAppealConfiguration;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.Ban;
import net.shortninja.staffplus.core.domain.staff.ban.playerbans.BanService;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@GuiController
public class BanAppealGuiController {
    private static final String CANCEL = "cancel";
    private static final int PAGE_SIZE = 45;
    private final AppealService appealService;
    private final BanService banService;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final BukkitUtils bukkitUtils;
    private final BanAppealConfiguration banAppealConfiguration;
    private final PermissionHandler permissionHandler;
    private final PlayerManager playerManager;

    public BanAppealGuiController(AppealService appealService, BanService banService, Messages messages, OnlineSessionsManager sessionManager, BukkitUtils bukkitUtils, BanAppealConfiguration banAppealConfiguration, PermissionHandler permissionHandler, PlayerManager playerManager) {
        this.appealService = appealService;
        this.banService = banService;
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.bukkitUtils = bukkitUtils;
        this.banAppealConfiguration = banAppealConfiguration;
        this.permissionHandler = permissionHandler;
        this.playerManager = playerManager;
    }

    @GuiAction(value="manage-ban-appeals/view/detail")
    public AsyncGui<GuiTemplate> getAppealDetail(@GuiParam(value="appealId") int appealId) {
        return AsyncGui.async(() -> {
            Appeal appeal = this.appealService.getAppeal(appealId);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("appeal", appeal);
            return GuiTemplate.template("gui/bans/appeal-detail.ftl", params);
        });
    }

    @GuiAction(value="manage-ban-appeals/view/create/reason-select")
    public GuiTemplate getCreateAppealReasonSelectView(@GuiParam(value="banId") int banId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action", "manage-ban-appeals/create?banId=" + banId);
        params.put("reasons", this.banAppealConfiguration.appealReasons);
        return GuiTemplate.template("gui/appeals/appeal-reason-select.ftl", params);
    }

    @GuiAction(value="manage-ban-appeals/view/create/reason-chat")
    public void getCreateAppealReasonChatView(Player player, @GuiParam(value="banId") int banId) {
        Ban ban = this.banService.getActiveById(banId);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         You have chosen to appeal this ban", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6            Type your appeal reason in chat", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&6         Type \"cancel\" to cancel appealing ", this.messages.prefixGeneral);
        this.messages.send((CommandSender)player, "&1=====================================================", this.messages.prefixGeneral);
        PlayerSession playerSession = this.sessionManager.get(player);
        playerSession.setChatAction((player1, input) -> {
            if (input.equalsIgnoreCase(CANCEL)) {
                this.messages.send((CommandSender)player, "&CYou have cancelled your appeal", this.messages.prefixBans);
                return;
            }
            SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
            Validator.validator(player).validateAnyPermission(this.banAppealConfiguration.createAppealPermission).validateNotEmpty(input, "Reason for appeal can not be empty");
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.addAppeal(sppPlayer, ban, input));
        });
    }

    @GuiAction(value="manage-ban-appeals/create")
    public void createAppeal(Player player, @GuiParam(value="banId") int banId, @GuiParam(value="reason") String reason) {
        Validator.validator(player).validateAnyPermission(this.banAppealConfiguration.createAppealPermission).validateNotEmpty(reason, "Reason for appeal can not be empty");
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        this.bukkitUtils.runTaskAsync((CommandSender)player, () -> {
            Ban ban = this.banService.getActiveById(banId);
            this.appealService.addAppeal(sppPlayer, ban, reason);
        });
    }

    @GuiAction(value="manage-bans/view/appealed-bans")
    public AsyncGui<GuiTemplate> appealedBansOverview(@GuiParam(value="page", defaultValue="0") int page) {
        return AsyncGui.async(() -> {
            List<Ban> bans = this.banService.getAppealedBans(page * 45, 45);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("bans", bans);
            return GuiTemplate.template("gui/bans/appealed-bans-overview.ftl", params);
        });
    }

    @GuiAction(value="manage-ban-appeals/approve")
    public void approveAppeal(Player player, @GuiParam(value="appealId") int appealId) {
        this.permissionHandler.validate((CommandSender)player, this.banAppealConfiguration.approveAppealPermission);
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        if (this.banAppealConfiguration.resolveReasonEnabled) {
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&6       You have chosen to approve this appeal", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&6Type your closing reason in chat to approve the appeal", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&6      Type \"cancel\" to cancel approving the appeal ", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&1===================================================", this.messages.prefixBans);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled approving this appeal", this.messages.prefixBans);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.approveAppeal(sppPlayer, appealId, message, AppealableType.BAN));
            });
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.approveAppeal(sppPlayer, appealId, AppealableType.BAN));
        }
    }

    @GuiAction(value="manage-ban-appeals/reject")
    public void rejectAppeal(Player player, @GuiParam(value="appealId") int appealId) {
        this.permissionHandler.validate((CommandSender)player, this.banAppealConfiguration.rejectAppealPermission);
        SppPlayer sppPlayer = this.playerManager.getOnlinePlayer(player.getUniqueId()).orElseThrow(() -> new PlayerNotFoundException(player.getName()));
        if (this.banAppealConfiguration.resolveReasonEnabled) {
            this.messages.send((CommandSender)player, "&1==================================================", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&6        You have chosen to reject this appeal", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&6Type your closing reason in chat to reject the appeal", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&6        Type \"cancel\" to cancel closing the appeal ", this.messages.prefixBans);
            this.messages.send((CommandSender)player, "&1==================================================", this.messages.prefixBans);
            PlayerSession playerSession = this.sessionManager.get(player);
            playerSession.setChatAction((player1, message) -> {
                if (message.equalsIgnoreCase(CANCEL)) {
                    this.messages.send((CommandSender)player, "&CYou have cancelled rejecting this appeal", this.messages.prefixBans);
                    return;
                }
                this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.rejectAppeal(sppPlayer, appealId, message, AppealableType.BAN));
            });
        } else {
            this.bukkitUtils.runTaskAsync((CommandSender)player, () -> this.appealService.rejectAppeal(sppPlayer, appealId, AppealableType.BAN));
        }
    }
}

