/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.appeals;

import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.appeals.Appeal;
import net.shortninja.staffplus.core.domain.staff.appeals.database.AppealRepository;
import net.shortninja.staffplusplus.appeals.AppealApprovedEvent;
import net.shortninja.staffplusplus.appeals.AppealRejectedEvent;
import net.shortninja.staffplusplus.appeals.AppealStatus;
import net.shortninja.staffplusplus.appeals.Appealable;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.appeals.AppealedEvent;
import net.shortninja.staffplusplus.session.SppPlayer;

@IocBean
public class AppealService {
    private final AppealRepository appealRepository;

    public AppealService(AppealRepository appealRepository) {
        this.appealRepository = appealRepository;
    }

    public void addAppeal(SppPlayer appealer, Appealable appealable, String reason) {
        Appeal appeal = new Appeal(appealable.getId(), appealer.getId(), appealer.getUsername(), reason, appealable.getType());
        this.appealRepository.findAppeal(appealable.getId(), appealable.getType()).ifPresent(a -> {
            throw new BusinessException("Appeal already exists for this " + (Object)((Object)appealable.getType()));
        });
        this.appealRepository.addAppeal(appeal, appealable.getType());
        appealable.setAppeal(appeal);
        BukkitUtils.sendEvent(new AppealedEvent(appealable));
    }

    public void approveAppeal(SppPlayer resolver, int appealId, AppealableType appealableType) {
        this.approveAppeal(resolver, appealId, null, appealableType);
    }

    public void approveAppeal(SppPlayer resolver, int appealId, String appealReason, AppealableType appealableType) {
        Appeal existingAppeal = this.appealRepository.findAppeal(appealId).orElseThrow(() -> new BusinessException("No appeal found with id: " + appealId));
        if (existingAppeal.getStatus() != AppealStatus.OPEN) {
            throw new BusinessException("Can not approve appeal. This appeal has already been resolved");
        }
        this.appealRepository.updateAppealStatus(appealId, resolver.getId(), resolver.getUsername(), appealReason, AppealStatus.APPROVED, appealableType);
        Appeal appeal = this.getAppeal(appealId);
        BukkitUtils.sendEvent(new AppealApprovedEvent(appeal));
    }

    public Appeal getAppeal(int appealId) {
        return this.appealRepository.findAppeal(appealId).orElseThrow(() -> new BusinessException("No appeal found with id: [" + appealId + "]"));
    }

    public void rejectAppeal(SppPlayer resolver, int appealId, AppealableType appealableType) {
        this.rejectAppeal(resolver, appealId, null, appealableType);
    }

    public void rejectAppeal(SppPlayer resolver, int appealId, String appealReason, AppealableType appealableType) {
        Appeal existingAppeal = this.appealRepository.findAppeal(appealId).orElseThrow(() -> new BusinessException("No appeal found with id: " + appealId));
        if (existingAppeal.getStatus() != AppealStatus.OPEN) {
            throw new BusinessException("Can not reject appeal. This appeal has already been resolved");
        }
        this.appealRepository.updateAppealStatus(appealId, resolver.getId(), resolver.getUsername(), appealReason, AppealStatus.REJECTED, appealableType);
        Appeal appeal = this.getAppeal(appealId);
        BukkitUtils.sendEvent(new AppealRejectedEvent(appeal));
    }
}

