/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.appeals;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplusplus.appeals.AppealStatus;
import net.shortninja.staffplusplus.appeals.AppealableType;
import net.shortninja.staffplusplus.appeals.IAppeal;

public class Appeal
implements IAppeal {
    private int id;
    private int appealableId;
    private UUID appealerUuid;
    private String appealerName;
    private UUID resolverUuid;
    private String resolverName;
    private String reason;
    private String resolveReason;
    private AppealStatus status;
    private Long timestamp;
    private AppealableType type;

    public Appeal(int id, int appealableId, UUID appealerUuid, String appealerName, UUID resolverUuid, String resolverName, String reason, String resolveReason, AppealStatus status, Long timestamp, AppealableType type) {
        this.id = id;
        this.appealableId = appealableId;
        this.appealerUuid = appealerUuid;
        this.appealerName = appealerName;
        this.resolverUuid = resolverUuid;
        this.resolverName = resolverName;
        this.reason = reason;
        this.resolveReason = resolveReason;
        this.status = status;
        this.timestamp = timestamp;
        this.type = type;
    }

    public Appeal(int appealableId, UUID appealerUuid, String appealerName, String reason, AppealableType type) {
        this.appealableId = appealableId;
        this.appealerUuid = appealerUuid;
        this.appealerName = appealerName;
        this.reason = reason;
        this.type = type;
        this.status = AppealStatus.OPEN;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getAppealableId() {
        return this.appealableId;
    }

    @Override
    public UUID getAppealerUuid() {
        return this.appealerUuid;
    }

    @Override
    public String getAppealerName() {
        return this.appealerName;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public AppealStatus getStatus() {
        return this.status;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public UUID getResolverUuid() {
        return this.resolverUuid;
    }

    @Override
    public String getResolverName() {
        return this.resolverName;
    }

    @Override
    public Optional<String> getResolveReason() {
        return Optional.ofNullable(this.resolveReason);
    }

    @Override
    public Long getCreationTimestamp() {
        return this.timestamp;
    }

    @Override
    public ZonedDateTime getCreationDate() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.timestamp), ZoneId.systemDefault());
    }

    @Override
    public AppealableType getType() {
        return this.type;
    }
}

