/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.altaccountdetect.cmd;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.cmd.AbstractCmd;
import net.shortninja.staffplus.core.common.cmd.Command;
import net.shortninja.staffplus.core.common.cmd.CommandService;
import net.shortninja.staffplus.core.common.cmd.SppCommand;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.AltDetectWhitelistedItem;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.AltDetectionService;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.command.CommandSender;

@Command(command="commands:alt-detect-whitelist", permissions={"permissions:alt-detect-check"}, description="Add/Remove players from the alt account detection whitelist", usage="[add/remove] [player1] [player2]")
@IocBean(conditionalOnProperty="alt-detect-module.enabled=true")
@IocMultiProvider(value={SppCommand.class})
public class AltDetectWhitelistCmd
extends AbstractCmd {
    private final AltDetectionService altDetectionService;
    private final PlayerManager playerManager;

    public AltDetectWhitelistCmd(Messages messages, AltDetectionService altDetectionService, CommandService commandService, PlayerManager playerManager, PermissionHandler permissionHandler) {
        super(messages, permissionHandler, commandService);
        this.altDetectionService = altDetectionService;
        this.playerManager = playerManager;
    }

    @Override
    protected boolean executeCmd(CommandSender sender, String alias, String[] args, SppPlayer player, Map<String, String> optionalParameters) {
        String action = args[0];
        if (action.equalsIgnoreCase("add")) {
            SppPlayer player1 = this.playerManager.getOnOrOfflinePlayer(args[1]).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            SppPlayer player2 = this.playerManager.getOnOrOfflinePlayer(args[2]).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            this.altDetectionService.addToWhitelist(sender, player1, player2);
            return true;
        }
        if (action.equalsIgnoreCase("remove")) {
            SppPlayer player1 = this.playerManager.getOnOrOfflinePlayer(args[1]).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            SppPlayer player2 = this.playerManager.getOnOrOfflinePlayer(args[2]).orElseThrow(() -> new BusinessException(this.messages.playerNotRegistered));
            this.altDetectionService.removeFromWhitelist(sender, player1, player2);
            return true;
        }
        if (action.equalsIgnoreCase("list")) {
            int page = args.length > 1 ? Integer.parseInt(args[1]) : 1;
            int offset = (page - 1) * 20;
            List<AltDetectWhitelistedItem> whitelistedItems = this.altDetectionService.getWhitelistedItems(sender, offset, 20);
            int counter = offset + 1;
            for (AltDetectWhitelistedItem whitelistedItem : whitelistedItems) {
                String whitelistPlayer1 = this.getPlayerName(whitelistedItem.getPlayerUuid1());
                String whitelistPlayer2 = this.getPlayerName(whitelistedItem.getPlayerUuid2());
                this.messages.send(sender, String.format("&B#%s: %s - %s", counter, whitelistPlayer1, whitelistPlayer2), this.messages.prefixGeneral);
                ++counter;
            }
            if (whitelistedItems.isEmpty()) {
                this.messages.send(sender, String.format("&6No items to display", page), this.messages.prefixGeneral);
            } else {
                this.messages.send(sender, String.format("&6Showing page #%s", page), this.messages.prefixGeneral);
            }
            return true;
        }
        throw new BusinessException(this.messages.invalidArguments.replace("%usage%", this.getName() + " &7" + this.getUsage()), this.messages.prefixGeneral);
    }

    private String getPlayerName(UUID uuid) {
        Optional<SppPlayer> player = this.playerManager.getOnOrOfflinePlayer(uuid);
        if (player.isPresent()) {
            return player.get().getUsername();
        }
        return "Unknown player with uuid [" + uuid + "]";
    }

    @Override
    protected int getMinimumArguments(CommandSender sender, String[] args) {
        if (args[0].equalsIgnoreCase("list")) {
            return 1;
        }
        return 3;
    }

    @Override
    protected Optional<String> getPlayerName(CommandSender sender, String[] args) {
        return Optional.empty();
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 1) {
            return Stream.of("add", "remove", "list").filter(s -> args[0].isEmpty() || s.contains(args[0])).collect(Collectors.toList());
        }
        if (args.length >= 1) {
            return this.playerManager.getAllPlayerNames().stream().filter(s -> args[args.length - 1].isEmpty() || s.contains(args[args.length - 1])).collect(Collectors.toList());
        }
        return super.tabComplete(sender, alias, args);
    }
}

