/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks;

import net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks.AltDetectInfo;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks.AltDetector;
import net.shortninja.staffplus.libs.org.apache.commons.lang.StringUtils;
import net.shortninja.staffplusplus.altdetect.AltDetectResultType;
import net.shortninja.staffplusplus.session.SppPlayer;

public class UsernameDetector
implements AltDetector {
    @Override
    public AltDetectResultType getResult(AltDetectInfo altDetectInfo, SppPlayer sppPlayer) {
        String strippedUsernameOtherPlayer;
        String strippedUsernamePlayer = this.stripUsername(altDetectInfo.getUsername());
        int levenshteinDistance = StringUtils.getLevenshteinDistance(strippedUsernamePlayer, strippedUsernameOtherPlayer = this.stripUsername(sppPlayer.getUsername()));
        double changePercentage = (double)levenshteinDistance / (double)Math.max(strippedUsernamePlayer.length(), strippedUsernameOtherPlayer.length());
        if (changePercentage <= 0.3) {
            return AltDetectResultType.NAME_SIMILARITY_70;
        }
        if (changePercentage <= 0.5) {
            return AltDetectResultType.NAME_SIMILARITY_50;
        }
        if (changePercentage <= 0.7) {
            return AltDetectResultType.NAME_SIMILARITY_30;
        }
        return null;
    }

    private String stripUsername(String username) {
        return username.toLowerCase().trim().replace("-", "").replace("_", "");
    }
}

