/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.altaccountdetect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.exceptions.NoPermissionException;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.ip.database.PlayerIpRepository;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.AltDetectResult;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.AltDetectWhitelistedItem;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks.AltDetectInfo;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks.AltDetector;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks.IpDetector;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.checks.UsernameDetector;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.config.AltDetectConfiguration;
import net.shortninja.staffplus.core.domain.staff.altaccountdetect.database.AltDetectWhitelistRepository;
import net.shortninja.staffplusplus.altdetect.AltDetectEvent;
import net.shortninja.staffplusplus.altdetect.AltDetectResultType;
import net.shortninja.staffplusplus.altdetect.IAltDetectResult;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

@IocBean
public class AltDetectionService {
    private final PlayerManager playerManager;
    private final List<AltDetector> altDetectors;
    private final PlayerIpRepository playerIpRepository;
    private final AltDetectWhitelistRepository altDetectWhitelistRepository;
    private final PermissionHandler permission;
    private final IpDetector ipDetector;
    private final AltDetectConfiguration altDetectConfiguration;

    public AltDetectionService(PlayerManager playerManager, PlayerIpRepository playerIpRepository, AltDetectWhitelistRepository altDetectWhitelistRepository, PermissionHandler permission, AltDetectConfiguration altDetectConfiguration) {
        this.playerManager = playerManager;
        this.ipDetector = new IpDetector(playerIpRepository);
        this.altDetectConfiguration = altDetectConfiguration;
        this.altDetectors = Arrays.asList(new UsernameDetector(), this.ipDetector);
        this.playerIpRepository = playerIpRepository;
        this.altDetectWhitelistRepository = altDetectWhitelistRepository;
        this.permission = permission;
    }

    public void addToWhitelist(CommandSender sender, SppPlayer player1, SppPlayer player2) {
        if (!this.permission.has(sender, this.altDetectConfiguration.whitelistPermission)) {
            throw new NoPermissionException();
        }
        this.altDetectWhitelistRepository.addWhitelistedItem(player1.getId(), player2.getId());
        sender.sendMessage("Successfully added to whitelist");
    }

    public void removeFromWhitelist(CommandSender sender, SppPlayer player1, SppPlayer player2) {
        if (!this.permission.has(sender, this.altDetectConfiguration.whitelistPermission)) {
            throw new NoPermissionException();
        }
        this.altDetectWhitelistRepository.removeWhitelistedItem(player1.getId(), player2.getId());
        sender.sendMessage("Successfully removed from whitelist");
    }

    public List<AltDetectWhitelistedItem> getWhitelistedItems(CommandSender sender, int offset, int amount) {
        if (!this.permission.has(sender, this.altDetectConfiguration.whitelistPermission)) {
            throw new NoPermissionException();
        }
        return this.altDetectWhitelistRepository.getAllPAgedWhitelistedItems(offset, amount);
    }

    public void detectAltAccount(SppPlayer player) {
        this.getAltAccounts(player).forEach(a -> Bukkit.getPluginManager().callEvent((Event)new AltDetectEvent((IAltDetectResult)a)));
    }

    public List<AltDetectResult> getAltAccounts(SppPlayer sppPlayer) {
        ArrayList<AltDetectResult> result = new ArrayList<AltDetectResult>();
        if (this.permission.has(sppPlayer.getOfflinePlayer(), this.altDetectConfiguration.bypassPermission)) {
            return result;
        }
        Player player = sppPlayer.isOnline() ? sppPlayer.getPlayer() : sppPlayer.getOfflinePlayer();
        String playerName = player.getName();
        String playerIp = this.getPlayerIp(sppPlayer);
        AltDetectInfo altDetectInfo = new AltDetectInfo(playerName, playerIp);
        List<AltDetectWhitelistedItem> whitelistedItems = this.altDetectWhitelistRepository.getWhitelistedItems(player.getUniqueId());
        Set playersToMatch = this.playerManager.getOnAndOfflinePlayers().stream().filter(arg_0 -> AltDetectionService.lambda$getAltAccounts$1((OfflinePlayer)player, arg_0)).filter(arg_0 -> this.lambda$getAltAccounts$2((OfflinePlayer)player, whitelistedItems, arg_0)).filter(onAndOfflinePlayer -> !this.altDetectConfiguration.sameIpRequired || this.ipDetector.getResult(altDetectInfo, (SppPlayer)onAndOfflinePlayer) == AltDetectResultType.SAME_IP).collect(Collectors.toSet());
        for (SppPlayer onAndOfflinePlayer2 : playersToMatch) {
            List<AltDetectResultType> altDetectResults = this.altDetectors.stream().map(a -> a.getResult(altDetectInfo, onAndOfflinePlayer2)).filter(Objects::nonNull).collect(Collectors.toList());
            if (altDetectResults.isEmpty()) continue;
            result.add(new AltDetectResult(player.getUniqueId(), playerName, onAndOfflinePlayer2.getId(), onAndOfflinePlayer2.getUsername(), altDetectResults));
        }
        return result;
    }

    private String getPlayerIp(SppPlayer sppPlayer) {
        String playerIp = sppPlayer.isOnline() ? BukkitUtils.getIpFromPlayer(sppPlayer.getPlayer()) : (String)this.playerIpRepository.getLastIp(sppPlayer.getId()).orElse(null);
        return playerIp;
    }

    private boolean isWhitelisted(OfflinePlayer player, List<AltDetectWhitelistedItem> whitelistedItems, SppPlayer onAndOfflinePlayer) {
        return whitelistedItems.stream().anyMatch(w -> w.isWhitelisted(player.getUniqueId(), onAndOfflinePlayer.getId()));
    }

    private /* synthetic */ boolean lambda$getAltAccounts$2(OfflinePlayer player, List whitelistedItems, SppPlayer onAndOfflinePlayer) {
        return !this.isWhitelisted(player, whitelistedItems, onAndOfflinePlayer);
    }

    private static /* synthetic */ boolean lambda$getAltAccounts$1(OfflinePlayer player, SppPlayer onAndOfflinePlayer) {
        return !onAndOfflinePlayer.getId().equals(player.getUniqueId());
    }
}

