/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.altaccountdetect;

import java.util.List;
import java.util.UUID;
import net.shortninja.staffplusplus.altdetect.AltDetectResultType;
import net.shortninja.staffplusplus.altdetect.AltDetectTrustLevel;
import net.shortninja.staffplusplus.altdetect.IAltDetectResult;

public class AltDetectResult
implements IAltDetectResult {
    private final UUID playerCheckedUuid;
    private final String playerCheckedName;
    private final UUID playerMatchedUuid;
    private final String playerMatchedName;
    private final boolean ipMatched;
    private final AltDetectTrustLevel altDetectTrustLevel;
    private final List<AltDetectResultType> altDetectResults;

    public AltDetectResult(UUID playerCheckedUuid, String playerCheckedName, UUID playerMatchedUuid, String playerMatchedName, List<AltDetectResultType> altDetectResults) {
        this.playerCheckedUuid = playerCheckedUuid;
        this.playerCheckedName = playerCheckedName;
        this.playerMatchedUuid = playerMatchedUuid;
        this.playerMatchedName = playerMatchedName;
        this.altDetectResults = altDetectResults;
        this.altDetectTrustLevel = AltDetectTrustLevel.fromScore(altDetectResults.stream().mapToInt(AltDetectResultType::getScore).sum());
        this.ipMatched = altDetectResults.contains((Object)AltDetectResultType.SAME_IP);
    }

    @Override
    public boolean isIpMatched() {
        return this.ipMatched;
    }

    @Override
    public UUID getPlayerCheckedUuid() {
        return this.playerCheckedUuid;
    }

    @Override
    public String getPlayerCheckedName() {
        return this.playerCheckedName;
    }

    @Override
    public UUID getPlayerMatchedUuid() {
        return this.playerMatchedUuid;
    }

    @Override
    public String getPlayerMatchedName() {
        return this.playerMatchedName;
    }

    @Override
    public AltDetectTrustLevel getAltDetectTrustLevel() {
        return this.altDetectTrustLevel;
    }

    @Override
    public List<AltDetectResultType> getAltDetectResultTypes() {
        return this.altDetectResults;
    }
}

