/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee.XrayAlertBungeeDto;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee.XrayAlertBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfigTransformer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(alerts-module.xray-alerts.notify-bungee)")
public class XrayAlertBungeeReceiver
implements PluginMessageListener {
    @ConfigProperty(value="alerts-module.xray-alerts.notify-bungee")
    @ConfigTransformer(value={ServerSyncConfigTransformer.class})
    private ServerSyncConfig syncServers;
    private final BungeeClient bungeeClient;

    public XrayAlertBungeeReceiver(BungeeClient bungeeClient) {
        this.bungeeClient = bungeeClient;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional xrayAlertBungeeDto = this.bungeeClient.handleReceived(channel, "staffplusplus.alerts.xray", message, XrayAlertBungeeDto.class);
        if (xrayAlertBungeeDto.isPresent() && this.syncServers.matchesServer(((XrayAlertBungeeDto)xrayAlertBungeeDto.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new XrayAlertBungeeEvent((XrayAlertBungeeDto)xrayAlertBungeeDto.get()));
        }
    }
}

