/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.common.bungee.BungeeMessage;
import net.shortninja.staffplus.core.domain.location.SppLocation;
import net.shortninja.staffplusplus.xray.XrayEvent;
import org.bukkit.Location;

public class XrayAlertBungeeDto
extends BungeeMessage {
    private final String playerName;
    private final UUID playerUuid;
    private final int amount;
    private final Long duration;
    private final String type;
    private final int lightLevel;
    private final SppLocation location;
    private final String pickaxeType;
    private final Map<String, Integer> pickaxeEnchantments;

    public XrayAlertBungeeDto(XrayEvent xrayEvent, String pickaxeType, Map<String, Integer> pickaxeEnchantments) {
        super(xrayEvent.getServerName());
        this.playerName = xrayEvent.getPlayer().getName();
        this.playerUuid = xrayEvent.getPlayer().getUniqueId();
        this.amount = xrayEvent.getAmount();
        this.duration = xrayEvent.getDuration().orElse(null);
        this.type = xrayEvent.getType().name();
        this.lightLevel = xrayEvent.getLightLevel();
        this.pickaxeType = pickaxeType;
        this.pickaxeEnchantments = pickaxeEnchantments;
        Location location = xrayEvent.getLocation();
        this.location = new SppLocation(location, xrayEvent.getServerName());
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public int getAmount() {
        return this.amount;
    }

    public Optional<Long> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    public String getType() {
        return this.type;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public SppLocation getLocation() {
        return this.location;
    }

    public Map<String, Integer> getPickaxeEnchantments() {
        return this.pickaxeEnchantments;
    }

    public String getPickaxeType() {
        return this.pickaxeType;
    }
}

