/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.xray;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class XrayTrace {
    private final Material blockType;
    private List<Long> timestamps;

    public XrayTrace(Material blockType) {
        this.blockType = blockType;
        this.timestamps = new ArrayList<Long>();
    }

    public int getAmount() {
        return this.timestamps.size();
    }

    public Material getBlockType() {
        return this.blockType;
    }

    public void addTrace(long timestamp) {
        this.timestamps.add(timestamp);
    }

    public void removeInvalidTimestamps(long minimumValidTimestamp) {
        this.timestamps = this.timestamps.stream().filter(time -> time >= minimumValidTimestamp).collect(Collectors.toList());
    }

    public long getDuration() {
        if (this.timestamps.isEmpty()) {
            return 0L;
        }
        return this.timestamps.get(this.timestamps.size() - 1) - this.timestamps.get(0);
    }
}

