/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.xray;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMulti;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.staff.alerts.config.XrayConfiguration;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayBlockConfig;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayStrategy;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayTrace;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

@IocBean
public class XrayService {
    private final List<XrayStrategy> xrayStrategies;
    private final XrayConfiguration xrayConfiguration;
    private final PermissionHandler permission;
    private static final Map<Player, Map<Material, XrayTrace>> playerTraces = new HashMap<Player, Map<Material, XrayTrace>>();

    public XrayService(@IocMulti(value=XrayStrategy.class) List<XrayStrategy> xrayStrategies, XrayConfiguration xrayConfiguration, PermissionHandler permission) {
        this.xrayStrategies = xrayStrategies;
        this.xrayConfiguration = xrayConfiguration;
        this.permission = permission;
    }

    public void handleBlockBreak(Block block, Player player) {
        if (this.permission.has(player, this.xrayConfiguration.permissionXrayBypass)) {
            return;
        }
        Optional<XrayBlockConfig> xrayBlockConfigOptional = this.xrayConfiguration.getBlockConfig(block.getType());
        if (!xrayBlockConfigOptional.isPresent()) {
            return;
        }
        XrayBlockConfig xrayBlockConfig = xrayBlockConfigOptional.get();
        long now = System.currentTimeMillis();
        this.addTrace(block.getType(), player, now);
        XrayTrace blockTrace = playerTraces.get(player).get(block.getType());
        Optional<XrayStrategy> xrayStrategy = this.xrayStrategies.stream().filter(s -> s.shouldHandle(xrayBlockConfig)).findFirst();
        if (xrayStrategy.isPresent() && xrayStrategy.get().handleBlockBreak(xrayBlockConfig, blockTrace, player, block)) {
            playerTraces.get(player).remove(block.getType());
        }
    }

    private void addTrace(Material blocktype, Player player, long now) {
        Map<Material, XrayTrace> playerTrace;
        if (!playerTraces.containsKey(player)) {
            playerTraces.put(player, new HashMap());
        }
        if (!(playerTrace = playerTraces.get(player)).containsKey(blocktype)) {
            playerTrace.put(blocktype, new XrayTrace(blocktype));
        }
        XrayTrace blockTrace = playerTrace.get(blocktype);
        blockTrace.addTrace(now);
    }

    public void clearTrace(Player player) {
        playerTraces.remove(player);
    }
}

