/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.xray;

import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocMultiProvider;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayBlockConfig;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayStrategy;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayTrace;
import net.shortninja.staffplusplus.xray.XrayEvent;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

@IocBean
@IocMultiProvider(value={XrayStrategy.class})
public class AmountAndDurationXrayStrategy
implements XrayStrategy {
    private final Options options;

    public AmountAndDurationXrayStrategy(Options options) {
        this.options = options;
    }

    @Override
    public boolean handleBlockBreak(XrayBlockConfig xrayBlockConfig, XrayTrace blockTrace, Player player, Block block) {
        byte lightLevel = player.getLocation().getBlock().getLightLevel();
        long minimumValidTimestamp = System.currentTimeMillis() - xrayBlockConfig.getDuration();
        blockTrace.removeInvalidTimestamps(minimumValidTimestamp);
        long duration = blockTrace.getDuration();
        if (blockTrace.getAmount() >= xrayBlockConfig.getAmountOfBlocks()) {
            BukkitUtils.sendEvent(new XrayEvent(player, blockTrace.getAmount(), duration, block.getType(), lightLevel, block.getLocation(), this.options.serverName, player.getInventory().getItemInMainHand()));
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldHandle(XrayBlockConfig xrayBlockConfig) {
        return xrayBlockConfig.getAmountOfBlocks() != null && xrayBlockConfig.getDuration() != null;
    }
}

