/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee.XrayAlertBungeeDto;
import net.shortninja.staffplusplus.xray.XrayEvent;

@IocBean
public class XrayLogger {
    private final Messages messages;

    public XrayLogger(Messages messages) {
        this.messages = messages;
    }

    public String getLogMessage(XrayEvent event) {
        ArrayList<String> enchantments = new ArrayList<String>();
        event.getPickaxe().getEnchantments().forEach((k, v) -> enchantments.add(JavaUtils.formatTypeName(k.getKey().getKey()) + " " + v));
        return this.getLogMessage(event.getPlayer().getName(), event.getAmount(), event.getType().name(), event.getLightLevel(), event.getDuration(), event.getServerName(), event.getPickaxe().getType().name(), enchantments);
    }

    public String getLogMessage(XrayAlertBungeeDto xrayAlertBungeeDto) {
        ArrayList<String> enchantments = new ArrayList<String>();
        xrayAlertBungeeDto.getPickaxeEnchantments().forEach((k, v) -> enchantments.add(JavaUtils.formatTypeName(k) + " " + v));
        return this.getLogMessage(xrayAlertBungeeDto.getPlayerName(), xrayAlertBungeeDto.getAmount(), xrayAlertBungeeDto.getType(), xrayAlertBungeeDto.getLightLevel(), xrayAlertBungeeDto.getDuration(), xrayAlertBungeeDto.getServerName(), xrayAlertBungeeDto.getPickaxeType(), enchantments);
    }

    private String getLogMessage(String playerName, int amount, String type, int lightLevel, Optional<Long> duration, String serverName, String toolType, List<String> enchantments) {
        String xrayMessage = this.messages.alertsXray.replace("%target%", playerName).replace("%count%", Integer.toString(amount)).replace("%server%", serverName).replace("%itemtype%", JavaUtils.formatTypeName(type)).replace("%tool-type%", JavaUtils.formatTypeName(toolType)).replace("%tool-enchantments%", String.join((CharSequence)"\\n", enchantments)).replace("%lightlevel%", Integer.toString(lightLevel));
        if (duration.isPresent()) {
            xrayMessage = xrayMessage + String.format(" in %s seconds", duration.get() / 1000L);
        }
        return xrayMessage;
    }
}

