/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.handlers;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.alerts.config.AlertsConfiguration;
import net.shortninja.staffplus.core.domain.staff.alerts.config.XrayConfiguration;
import net.shortninja.staffplus.core.domain.staff.alerts.handlers.AlertsHandler;
import net.shortninja.staffplus.core.domain.staff.alerts.handlers.XrayLogger;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee.XrayAlertBungeeDto;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.bungee.XrayAlertBungeeEvent;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.xray.XrayEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener(conditionalOnProperty="alerts-module.xray-alerts.enabled=true")
public class XrayAlertHandler
extends AlertsHandler
implements Listener {
    private final XrayConfiguration xrayConfiguration;
    private final XrayLogger xrayLogger;

    public XrayAlertHandler(AlertsConfiguration alertsConfiguration, PlayerSettingsRepository playerSettingsRepository, OnlineSessionsManager sessionManager, PermissionHandler permission, Messages messages, XrayConfiguration xrayConfiguration, PlayerManager playerManager, XrayLogger xrayLogger) {
        super(alertsConfiguration, playerSettingsRepository, sessionManager, permission, messages, playerManager);
        this.xrayConfiguration = xrayConfiguration;
        this.xrayLogger = xrayLogger;
    }

    @EventHandler
    public void handle(XrayEvent event) {
        this.messages.send(this.getPlayersToNotify(), this.xrayLogger.getLogMessage(event), this.messages.prefixGeneral);
    }

    @EventHandler
    public void handle(XrayAlertBungeeEvent event) {
        XrayAlertBungeeDto xrayAlertBungeeDto = event.getXrayAlertBungeeDto();
        this.messages.send(this.getPlayersToNotify(), this.xrayLogger.getLogMessage(xrayAlertBungeeDto), this.messages.prefixGeneral);
    }

    @Override
    protected AlertType getType() {
        return AlertType.XRAY;
    }

    @Override
    protected String getPermission() {
        return this.xrayConfiguration.permissionXray;
    }
}

