/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.handlers;

import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.chat.mention.bungee.MentionBungeeDto;
import net.shortninja.staffplus.core.domain.chat.mention.bungee.PlayerMentionedBungeeEvent;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.alerts.config.AlertsConfiguration;
import net.shortninja.staffplus.core.domain.staff.alerts.handlers.AlertsHandler;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.chat.PlayerMentionedEvent;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener(conditionalOnProperty="alerts-module.mention-notify=true")
public class PlayerMentionAlertHandler
extends AlertsHandler
implements Listener {
    private final Options options;

    public PlayerMentionAlertHandler(AlertsConfiguration alertsConfiguration, PlayerSettingsRepository playerSettingsRepository, OnlineSessionsManager sessionManager, PermissionHandler permission, Messages messages, PlayerManager playerManager, Options options) {
        super(alertsConfiguration, playerSettingsRepository, sessionManager, permission, messages, playerManager);
        this.options = options;
    }

    @EventHandler
    public void handle(PlayerMentionedEvent event) {
        this.notifyMentionedPlayer(event.getMentionedPlayer().getUniqueId(), event.getPlayer().getName(), this.options.serverName);
    }

    @EventHandler
    public void handle(PlayerMentionedBungeeEvent event) {
        MentionBungeeDto mentionBungeeDto = event.getMentionBungeeDto();
        this.notifyMentionedPlayer(mentionBungeeDto.getMentionedPlayerUuid(), mentionBungeeDto.getPlayerName(), mentionBungeeDto.getServerName());
    }

    private void notifyMentionedPlayer(UUID mentionedPlayerUuid, String playerName, String serverName) {
        Optional<SppPlayer> onlinePlayer = this.playerManager.getOnlinePlayer(mentionedPlayerUuid);
        onlinePlayer.ifPresent(mentioned -> {
            Player mentionedPlayer = mentioned.getPlayer();
            PlayerSettings session = this.playerSettingsRepository.get((OfflinePlayer)mentionedPlayer);
            if (session.getAlertOptions().contains((Object)AlertType.MENTION) && this.permission.has(mentionedPlayer, this.alertsConfiguration.permissionMention)) {
                this.messages.send(mentionedPlayer, this.messages.alertsMention.replace("%server%", serverName).replace("%target%", playerName), this.messages.prefixGeneral, this.alertsConfiguration.permissionMention);
                if (this.alertsConfiguration.alertsSound != null) {
                    this.alertsConfiguration.alertsSound.play(mentionedPlayer);
                }
            }
        });
    }

    @Override
    protected AlertType getType() {
        return AlertType.MENTION;
    }

    @Override
    protected String getPermission() {
        return this.alertsConfiguration.permissionMention;
    }
}

