/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.handlers;

import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.chat.bungee.PhraseDetectedBungeeDto;
import net.shortninja.staffplus.core.domain.chat.bungee.PhraseDetectedBungeeEvent;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.alerts.config.AlertsConfiguration;
import net.shortninja.staffplus.core.domain.staff.alerts.handlers.AlertsHandler;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.chat.PhrasesDetectedEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener(conditionalOnProperty="alerts-module.chat-phrase-detection=true")
public class ChatPhraseDetectedAlertHandler
extends AlertsHandler
implements Listener {
    public ChatPhraseDetectedAlertHandler(AlertsConfiguration alertsConfiguration, OnlineSessionsManager sessionManager, PlayerSettingsRepository playerSettingsRepository, PermissionHandler permission, Messages messages, PlayerManager playerManager) {
        super(alertsConfiguration, playerSettingsRepository, sessionManager, permission, messages, playerManager);
    }

    @EventHandler
    public void handle(PhrasesDetectedEvent phrasesDetectedEvent) {
        this.notifyPlayers(phrasesDetectedEvent.getPlayer().getName(), phrasesDetectedEvent.getOriginalMessage(), phrasesDetectedEvent.getDetectedPhrases(), phrasesDetectedEvent.getServerName());
    }

    @EventHandler
    public void handle(PhraseDetectedBungeeEvent phraseDetectedBungeeEvent) {
        PhraseDetectedBungeeDto detectedBungeeDto = phraseDetectedBungeeEvent.getPhraseDetectedBungeeDto();
        this.notifyPlayers(detectedBungeeDto.getPlayerName(), detectedBungeeDto.getOriginalMessage(), detectedBungeeDto.getDetectedPhrases(), detectedBungeeDto.getServerName());
    }

    private void notifyPlayers(String playerName, String originalMessage, List<String> detectedPhrases, String serverName) {
        for (Player player : this.getPlayersToNotify()) {
            this.messages.send(player, this.messages.alertsChatPhraseDetected.replace("%target%", playerName).replace("%server%", serverName).replace("%originalMessage%", originalMessage).replace("%detectedPhrases%", String.join((CharSequence)" | ", detectedPhrases)), this.messages.prefixGeneral, this.getPermission());
        }
    }

    @Override
    protected AlertType getType() {
        return AlertType.CHAT_PHRASE_DETECTION;
    }

    @Override
    protected String getPermission() {
        return this.alertsConfiguration.permissionChatPhraseDetection;
    }
}

