/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.handlers;

import java.util.List;
import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.TubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.load.InjectTubingPlugin;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.chat.bungee.PhraseDetectedBungeeDto;
import net.shortninja.staffplus.core.domain.chat.bungee.PhraseDetectedBungeeEvent;
import net.shortninja.staffplusplus.chat.PhrasesDetectedEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener(conditionalOnProperty="alerts-module.chat-phrase-detection-console=true")
public class ChatPhraseDetectedAlertConsoleHandler
implements Listener {
    private final Messages messages;
    private final TubingPlugin tubingPlugin;

    public ChatPhraseDetectedAlertConsoleHandler(Messages messages, @InjectTubingPlugin TubingPlugin tubingPlugin) {
        this.messages = messages;
        this.tubingPlugin = tubingPlugin;
    }

    @EventHandler
    public void handle(PhrasesDetectedEvent phrasesDetectedEvent) {
        this.log(phrasesDetectedEvent.getPlayer().getName(), phrasesDetectedEvent.getOriginalMessage(), phrasesDetectedEvent.getDetectedPhrases(), phrasesDetectedEvent.getServerName());
    }

    @EventHandler
    public void handle(PhraseDetectedBungeeEvent phraseDetectedBungeeEvent) {
        PhraseDetectedBungeeDto phraseDetectedBungeeDto = phraseDetectedBungeeEvent.getPhraseDetectedBungeeDto();
        this.log(phraseDetectedBungeeDto.getPlayerName(), phraseDetectedBungeeDto.getOriginalMessage(), phraseDetectedBungeeDto.getDetectedPhrases(), phraseDetectedBungeeDto.getServerName());
    }

    private void log(String target, String originalMessage, List<String> detectedPhrases, String serverName) {
        String message = this.messages.alertsChatPhraseDetected.replace("%target%", target).replace("%server%", serverName).replace("%originalMessage%", originalMessage).replace("%detectedPhrases%", String.join((CharSequence)" | ", detectedPhrases));
        this.tubingPlugin.getLogger().info(message);
    }
}

