/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.handlers;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.permissions.PermissionHandler;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.alerts.config.AlertsConfiguration;
import net.shortninja.staffplus.core.domain.staff.alerts.handlers.AlertsHandler;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.altdetect.AltDetectEvent;
import net.shortninja.staffplusplus.altdetect.IAltDetectResult;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

@IocBukkitListener
public class AltDetectAlertHandler
extends AlertsHandler
implements Listener {
    public AltDetectAlertHandler(AlertsConfiguration alertsConfiguration, OnlineSessionsManager sessionManager, PlayerSettingsRepository playerSettingsRepository, PermissionHandler permission, Messages messages, PlayerManager playerManager) {
        super(alertsConfiguration, playerSettingsRepository, sessionManager, permission, messages, playerManager);
    }

    @EventHandler
    public void altDetect(AltDetectEvent altDetectEvent) {
        IAltDetectResult altDetectResult = altDetectEvent.getAltDetectResult();
        if (!this.alertsConfiguration.alertsAltDetectEnabled || !this.alertsConfiguration.alertsAltDetectTrustLevels.contains((Object)altDetectResult.getAltDetectTrustLevel())) {
            return;
        }
        for (Player player : this.getPlayersToNotify()) {
            this.messages.send((CommandSender)player, String.format("&CAlt account check triggered, %s and %s might be the same player. Trust [%s]", new Object[]{altDetectResult.getPlayerCheckedName(), altDetectResult.getPlayerMatchedName(), altDetectResult.getAltDetectTrustLevel()}), this.messages.prefixGeneral);
        }
    }

    @Override
    protected AlertType getType() {
        return AlertType.ALT_DETECT;
    }

    @Override
    protected String getPermission() {
        return this.alertsConfiguration.permissionAlertsAltDetect;
    }
}

