/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.staff.alerts.config;

import java.util.List;
import net.shortninja.staffplus.core.application.config.SoundsConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.common.Sounds;
import net.shortninja.staffplus.core.common.exceptions.BusinessException;
import net.shortninja.staffplus.core.domain.staff.alerts.config.AltDetectTrustLevelConfigTransformer;
import net.shortninja.staffplus.core.domain.staff.alerts.config.XrayConfiguration;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.altdetect.AltDetectTrustLevel;

@IocBean
public class AlertsConfiguration {
    @ConfigProperty(value="alerts-module.alt-detect-notify.enabled")
    public boolean alertsAltDetectEnabled;
    @ConfigProperty(value="alerts-module.alt-detect-notify.trust-levels")
    @ConfigTransformer(value={AltDetectTrustLevelConfigTransformer.class})
    public List<AltDetectTrustLevel> alertsAltDetectTrustLevels;
    @ConfigProperty(value="permissions:alerts.notifications.alt-detect")
    public String permissionAlertsAltDetect;
    @ConfigProperty(value="permissions:alerts.notifications.mention")
    public String permissionMention;
    @ConfigProperty(value="permissions:alerts.notifications.name-change")
    public String permissionNameChange;
    @ConfigProperty(value="permissions:alerts.notifications.chat-phrase-detection")
    public String permissionChatPhraseDetection;
    @ConfigProperty(value="permissions:alerts.notifications.blacklist-detection")
    public String permissionBlacklistDetection;
    @ConfigProperty(value="permissions:alerts.notifications.command-detection")
    public String permissionCommandDetection;
    @ConfigProperty(value="alerts-module.sound")
    @ConfigTransformer(value={SoundsConfigTransformer.class})
    public Sounds alertsSound;
    private final XrayConfiguration xrayConfiguration;

    public AlertsConfiguration(XrayConfiguration xrayConfiguration) {
        this.xrayConfiguration = xrayConfiguration;
    }

    public String getPermissionForType(AlertType alertType) {
        switch (alertType) {
            case XRAY: {
                return this.xrayConfiguration.permissionXray;
            }
            case MENTION: {
                return this.permissionMention;
            }
            case ALT_DETECT: {
                return this.permissionAlertsAltDetect;
            }
            case NAME_CHANGE: {
                return this.permissionNameChange;
            }
            case CHAT_PHRASE_DETECTION: {
                return this.permissionChatPhraseDetection;
            }
            case COMMAND_DETECTION: {
                return this.permissionCommandDetection;
            }
            case BLACKLIST: {
                return this.permissionBlacklistDetection;
            }
        }
        throw new BusinessException("&CUnsupported alertType [" + (Object)((Object)alertType) + "]");
    }
}

