/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.settings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.shortninja.staffplus.core.application.config.Options;
import net.shortninja.staffplus.core.application.session.database.PlayerSettingsEntity;
import net.shortninja.staffplus.core.application.session.database.PlayerSettingsSqlRepository;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingCreationException;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsDataFile;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

@IocBean
public class PlayerSettingsRepository {
    private final Options options;
    private final PlayerSettingsSqlRepository playerSettingsSqlRepository;
    private final PlayerSettingsDataFile playerSettingsDataFile;
    private final FileConfiguration dataFileConfiguration;
    private final Map<UUID, PlayerSettings> settingsMap = new ConcurrentHashMap<UUID, PlayerSettings>();

    public PlayerSettingsRepository(Options options, PlayerSettingsSqlRepository playerSettingsSqlRepository, PlayerSettingsDataFile playerSettingsDataFile) {
        this.options = options;
        this.playerSettingsSqlRepository = playerSettingsSqlRepository;
        this.dataFileConfiguration = playerSettingsDataFile.getConfiguration();
        this.playerSettingsDataFile = playerSettingsDataFile;
    }

    public PlayerSettings get(OfflinePlayer player) {
        if (this.settingsMap.containsKey(player.getUniqueId())) {
            return this.settingsMap.get(player.getUniqueId());
        }
        if (!this.dataFileConfiguration.contains(player.getUniqueId().toString())) {
            PlayerSettings settings = this.createSession(player);
            this.settingsMap.put(player.getUniqueId(), settings);
            return settings;
        }
        PlayerSettings playerSettings = this.retrieveSettings(player.getUniqueId());
        this.settingsMap.put(player.getUniqueId(), playerSettings);
        return playerSettings;
    }

    public void clearSettings(OfflinePlayer offlinePlayer) {
        this.settingsMap.remove(offlinePlayer.getUniqueId());
    }

    public synchronized PlayerSettings createSession(OfflinePlayer player) {
        if (this.dataFileConfiguration.contains(player.getUniqueId().toString())) {
            throw new PlayerSettingCreationException("A session for this player already exists. Cannot create new one.");
        }
        PlayerSettings playerSettings = new PlayerSettings(player.getUniqueId(), player.getName(), Material.WHITE_STAINED_GLASS_PANE, new HashSet<AlertType>(), VanishType.NONE, false, null, new HashSet<String>(), new HashSet<String>(), new HashMap<String, Boolean>());
        this.playerSettingsDataFile.save(playerSettings);
        if (this.options.serverSyncConfiguration.sessionSyncEnabled()) {
            this.updateSqlSettings(playerSettings);
        }
        this.settingsMap.put(player.getUniqueId(), playerSettings);
        return playerSettings;
    }

    private PlayerSettings retrieveSettings(UUID uuid) {
        String name = this.dataFileConfiguration.getString(uuid + ".name");
        String glassColor = this.dataFileConfiguration.getString(uuid + ".glass-color");
        Material glassMaterial = Material.WHITE_STAINED_GLASS_PANE;
        if (glassColor != null && !glassColor.equals("0")) {
            glassMaterial = Material.valueOf((String)glassColor);
        }
        Set<AlertType> alertOptions = this.loadAlertOptions(uuid);
        Optional<PlayerSettingsEntity> settingsEntity = this.playerSettingsSqlRepository.findSettings(uuid);
        VanishType vanishType = this.getVanishType(uuid, settingsEntity);
        Set mutedChannels = settingsEntity.map(PlayerSettingsEntity::getMutedStaffChatChannels).orElse(new HashSet());
        Set soundDisabledStaffChatChannels = settingsEntity.map(PlayerSettingsEntity::getSoundDisabledStaffChatChannels).orElse(new HashSet());
        boolean staffMode = this.dataFileConfiguration.getBoolean(uuid + ".staff-mode", false);
        String nightVisionString = this.dataFileConfiguration.getString(uuid + ".night-vision", "");
        Map<String, Boolean> nightVision = this.mapNightVision(nightVisionString);
        String staffModeName = this.dataFileConfiguration.getString(uuid + ".staff-mode-name", null);
        if (this.options.serverSyncConfiguration.staffModeSyncEnabled && settingsEntity.isPresent()) {
            staffMode = settingsEntity.get().getStaffMode();
            staffModeName = settingsEntity.get().getStaffModeName();
        }
        return new PlayerSettings(uuid, name, glassMaterial, alertOptions, vanishType, staffMode, staffModeName, mutedChannels, soundDisabledStaffChatChannels, nightVision);
    }

    @NotNull
    private Map<String, Boolean> mapNightVision(String nightVisionString) {
        String[] split;
        HashMap<String, Boolean> nightVision = new HashMap<String, Boolean>();
        for (String s : split = nightVisionString.split(";")) {
            String[] split1 = s.split(",");
            if (split1.length != 2) continue;
            String initiator = split1[0];
            boolean value = Boolean.parseBoolean(split1[1]);
            nightVision.put(initiator, value);
        }
        return nightVision;
    }

    @NotNull
    private VanishType getVanishType(UUID uuid, Optional<PlayerSettingsEntity> settingsEntity) {
        VanishType vanishType = VanishType.valueOf(this.dataFileConfiguration.getString(uuid + ".vanish-type", "NONE"));
        if (this.options.serverSyncConfiguration.vanishSyncEnabled) {
            vanishType = settingsEntity.map(PlayerSettingsEntity::getVanishType).orElse(vanishType);
        }
        return vanishType;
    }

    private Set<AlertType> loadAlertOptions(UUID uuid) {
        HashSet<AlertType> alertOptions = new HashSet<AlertType>();
        for (String string : this.dataFileConfiguration.getStringList(uuid + ".alert-options")) {
            String[] parts = string.split(";");
            boolean enabled = Boolean.parseBoolean(parts[1]);
            if (!enabled) continue;
            alertOptions.add(AlertType.valueOf(parts[0]));
        }
        return alertOptions;
    }

    public synchronized void save(PlayerSettings playerSession) {
        this.playerSettingsDataFile.save(playerSession);
        if (this.options.serverSyncConfiguration.sessionSyncEnabled()) {
            this.updateSqlSettings(playerSession);
        }
        this.settingsMap.put(playerSession.getUuid(), playerSession);
    }

    private void updateSqlSettings(PlayerSettings playerSession) {
        Optional<PlayerSettingsEntity> session = this.playerSettingsSqlRepository.findSettings(playerSession.getUuid());
        String staffModeName = playerSession.getModeName().orElse(null);
        if (session.isPresent()) {
            if (this.options.serverSyncConfiguration.vanishSyncEnabled) {
                session.get().setVanishType(playerSession.getVanishType());
            }
            if (this.options.serverSyncConfiguration.staffModeSyncEnabled) {
                session.get().setStaffMode(playerSession.isInStaffMode());
                session.get().setStaffModeName(staffModeName);
            }
            session.get().setMutedStaffChatChannels(playerSession.getMutedStaffChatChannels());
            session.get().setSoundDisabledStaffChatChannels(playerSession.getSoundDisabledStaffChatChannels());
            this.playerSettingsSqlRepository.update(session.get());
        } else {
            this.playerSettingsSqlRepository.saveSessions(new PlayerSettingsEntity(playerSession.getUuid(), playerSession.getVanishType(), playerSession.isInStaffMode(), playerSession.getMutedStaffChatChannels(), playerSession.getSoundDisabledStaffChatChannels(), staffModeName));
        }
    }
}

