/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.settings;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.shortninja.staffplus.core.StaffPlusPlus;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.IocBean;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

@IocBean
public class PlayerSettingsDataFile {
    private static final String DATA_YML = "data.yml";
    private final YamlConfiguration configuration;

    public PlayerSettingsDataFile() {
        File file = new File(StaffPlusPlus.get().getDataFolder(), DATA_YML);
        if (!file.exists()) {
            StaffPlusPlus.get().saveResource(DATA_YML, false);
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
    }

    public synchronized void save(PlayerSettings settings) {
        try {
            File file = new File(StaffPlusPlus.get().getDataFolder(), DATA_YML);
            this.updateSettings(settings);
            this.configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void save(Collection<PlayerSettings> settings) {
        try {
            File file = new File(StaffPlusPlus.get().getDataFolder(), DATA_YML);
            settings.forEach(this::updateSettings);
            this.configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void updateSettings(PlayerSettings settings) {
        this.configuration.set(settings.getUuid() + ".name", (Object)settings.getName());
        this.configuration.set(settings.getUuid() + ".glass-color", (Object)(settings.getGlassColor() != null ? settings.getGlassColor().name() : Material.WHITE_STAINED_GLASS_PANE));
        this.configuration.set(settings.getUuid() + ".alert-options", this.alertOptions(settings));
        this.configuration.set(settings.getUuid() + ".vanish-type", (Object)(settings.getVanishType() != null ? settings.getVanishType().name() : VanishType.NONE.name()));
        this.configuration.set(settings.getUuid() + ".staff-mode", (Object)settings.isInStaffMode());
        this.configuration.set(settings.getUuid() + ".staff-mode-name", settings.getModeName().orElse(null));
        this.configuration.set(settings.getUuid() + ".night-vision", (Object)this.mapNightVision(settings.getNightVision()));
    }

    private String mapNightVision(Map<String, Boolean> nightVision) {
        return nightVision.keySet().stream().map(key -> key + "," + nightVision.get(key)).collect(Collectors.joining(";"));
    }

    private List<String> alertOptions(PlayerSettings session) {
        return session.getAlertOptions().stream().map(alertType -> alertType.name() + ";" + true).collect(Collectors.toList());
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }
}

