/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.settings;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplusplus.alerts.AlertType;
import net.shortninja.staffplusplus.vanish.VanishType;
import org.bukkit.Material;

public class PlayerSettings {
    private final UUID uuid;
    private final Set<AlertType> alertOptions;
    private final Set<String> mutedStaffChatChannels;
    private final Set<String> soundDisabledStaffChatChannels;
    private String name;
    private Material glassColor;
    private VanishType vanishType;
    private boolean inStaffMode;
    private final Map<String, Boolean> nightVision;
    private String modeName;

    public PlayerSettings(UUID uuid, String name, Material glassColor, Set<AlertType> alertOptions, VanishType vanishType, boolean inStaffMode, String modeName, Set<String> mutedStaffChatChannels, Set<String> soundDisabledStaffChatChannels, Map<String, Boolean> nightVision) {
        this.uuid = uuid;
        this.name = name;
        this.glassColor = glassColor;
        this.alertOptions = alertOptions;
        this.vanishType = vanishType;
        this.inStaffMode = inStaffMode;
        this.modeName = modeName;
        this.mutedStaffChatChannels = mutedStaffChatChannels;
        this.soundDisabledStaffChatChannels = soundDisabledStaffChatChannels;
        this.nightVision = nightVision;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public Material getGlassColor() {
        return this.glassColor;
    }

    public Set<AlertType> getAlertOptions() {
        return this.alertOptions;
    }

    public VanishType getVanishType() {
        return this.vanishType;
    }

    public boolean isInStaffMode() {
        return this.inStaffMode;
    }

    public Optional<String> getModeName() {
        return Optional.ofNullable(this.modeName);
    }

    public Set<String> getMutedStaffChatChannels() {
        return this.mutedStaffChatChannels;
    }

    public Set<String> getSoundDisabledStaffChatChannels() {
        return this.soundDisabledStaffChatChannels;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isVanished() {
        return this.vanishType == VanishType.TOTAL || this.vanishType == VanishType.PLAYER;
    }

    public void setVanishType(VanishType vanishType) {
        this.vanishType = vanishType;
    }

    public void setGlassColor(Material glassColor) {
        this.glassColor = glassColor;
    }

    public boolean isStaffChatMuted(String channelName) {
        return this.mutedStaffChatChannels.contains(channelName);
    }

    public boolean isStaffChatSoundEnabled(String channelName) {
        return !this.soundDisabledStaffChatChannels.contains(channelName);
    }

    public void setModeConfiguration(GeneralModeConfiguration modeConfiguration) {
        this.modeName = modeConfiguration.getName();
    }

    public void setModeName(String modeName) {
        this.modeName = modeName;
    }

    public void setInStaffMode(boolean staffMode) {
        this.inStaffMode = staffMode;
    }

    public void setStaffChatMuted(String name, boolean muted) {
        if (muted) {
            this.mutedStaffChatChannels.add(name);
        } else {
            this.mutedStaffChatChannels.remove(name);
        }
    }

    public void setStaffChatNotificationSound(String name, boolean enabled) {
        if (enabled) {
            this.soundDisabledStaffChatChannels.remove(name);
        } else {
            this.soundDisabledStaffChatChannels.add(name);
        }
    }

    public void setAlertOption(AlertType alertType, boolean isEnabled) {
        if (isEnabled) {
            this.alertOptions.add(alertType);
        } else {
            this.alertOptions.remove((Object)alertType);
        }
    }

    public boolean isNightVisionEnabled() {
        return this.nightVision.values().stream().anyMatch(n -> n);
    }

    public Map<String, Boolean> getNightVision() {
        return this.nightVision;
    }

    public void setNightVision(String initiator, boolean nightVision) {
        this.nightVision.put(initiator, nightVision);
    }
}

