/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.namechanged.bungee;

import java.util.Optional;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigTransformer;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitMessageListener;
import net.shortninja.staffplus.core.common.bungee.BungeeClient;
import net.shortninja.staffplus.core.domain.player.namechanged.bungee.NameChangeBungeeDto;
import net.shortninja.staffplus.core.domain.player.namechanged.bungee.NameChangedBungeeEvent;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfig;
import net.shortninja.staffplus.core.domain.synchronization.ServerSyncConfigTransformer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.messaging.PluginMessageListener;

@IocBukkitMessageListener(channel="BungeeCord", conditionalOnProperty="isNotEmpty(alerts-module.name-notify-bungee)")
public class NameChangedBungeeReceiver
implements PluginMessageListener {
    @ConfigProperty(value="alerts-module.name-notify-bungee")
    @ConfigTransformer(value={ServerSyncConfigTransformer.class})
    private ServerSyncConfig syncServers;
    private final BungeeClient bungeeClient;

    public NameChangedBungeeReceiver(BungeeClient bungeeClient) {
        this.bungeeClient = bungeeClient;
    }

    public void onPluginMessageReceived(String channel, Player player, byte[] message) {
        Optional nameChangeBungeeDto = this.bungeeClient.handleReceived(channel, "staffplusplus.alerts.name-change", message, NameChangeBungeeDto.class);
        if (nameChangeBungeeDto.isPresent() && this.syncServers.matchesServer(((NameChangeBungeeDto)nameChangeBungeeDto.get()).getServerName())) {
            Bukkit.getPluginManager().callEvent((Event)new NameChangedBungeeEvent((NameChangeBungeeDto)nameChangeBungeeDto.get()));
        }
    }
}

