/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import net.shortninja.staffplus.core.application.config.messages.Messages;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.configuration.ConfigProperty;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import net.shortninja.staffplus.core.domain.staff.alerts.xray.XrayService;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeHandler;
import net.shortninja.staffplus.core.domain.staff.freeze.config.FreezeConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.StaffModeService;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceService;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

@IocBukkitListener
public class PlayerQuit
implements Listener {
    @ConfigProperty(value="permissions:freeze")
    private String permissionFreeze;
    private final Messages messages;
    private final OnlineSessionsManager sessionManager;
    private final StaffModeService staffModeService;
    private final TraceService traceService;
    private final XrayService xrayService;
    private final IProtocolService protocolService;
    private final FreezeConfiguration freezeConfiguration;
    private final PlayerSettingsRepository playerSettingsRepository;
    private final FreezeHandler freezeHandler;

    public PlayerQuit(Messages messages, OnlineSessionsManager sessionManager, StaffModeService staffModeService, TraceService traceService, XrayService xrayService, IProtocolService protocolService, FreezeConfiguration freezeConfiguration, PlayerSettingsRepository playerSettingsRepository, FreezeHandler freezeHandler) {
        this.messages = messages;
        this.sessionManager = sessionManager;
        this.staffModeService = staffModeService;
        this.traceService = traceService;
        this.xrayService = xrayService;
        this.protocolService = protocolService;
        this.freezeConfiguration = freezeConfiguration;
        this.playerSettingsRepository = playerSettingsRepository;
        this.freezeHandler = freezeHandler;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onQuit(PlayerQuitEvent event) {
        this.protocolService.getVersionProtocol().uninject(event.getPlayer());
        Player player = event.getPlayer();
        PlayerSession session = this.sessionManager.get(player);
        if (session.isVanished()) {
            event.setQuitMessage("");
        }
        if (session.isFrozen()) {
            for (String command : this.freezeConfiguration.logoutCommands) {
                command = command.replace("%player%", player.getName());
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
            this.freezeHandler.removeFreeze((CommandSender)Bukkit.getConsoleSender(), player);
        }
        this.traceService.sendTraceMessage(player.getUniqueId(), "Left the game");
        this.traceService.stopAllTracesForPlayer(player.getUniqueId());
        this.xrayService.clearTrace(player);
        if (session.isFrozen()) {
            this.messages.sendGroupMessage(this.messages.freezeLogout.replace("%player%", player.getName()), this.permissionFreeze, this.messages.prefixGeneral);
        }
        if (session.isInStaffMode() && session.getModeConfig().get().isModeDisableOnLogout()) {
            this.staffModeService.turnStaffModeOffOnQuit(player);
        }
        this.playerSettingsRepository.clearSettings((OfflinePlayer)player);
    }
}

