/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceService;
import net.shortninja.staffplus.core.domain.staff.tracing.TraceType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;

@IocBukkitListener
public class PlayerPickupItem
implements Listener {
    private final TraceService traceService;
    private final OnlineSessionsManager sessionManager;

    public PlayerPickupItem(TraceService traceService, OnlineSessionsManager sessionManager) {
        this.traceService = traceService;
        this.sessionManager = sessionManager;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPickup(EntityPickupItemEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            PlayerSession session = this.sessionManager.get(player);
            if (!session.isInStaffMode() || session.getModeConfig().get().isModeItemPickup()) {
                this.traceService.sendTraceMessage(TraceType.PICKUP_ITEM, player.getUniqueId(), String.format("Picked up item [%s]", event.getItem().getItemStack().getType()));
                return;
            }
            event.setCancelled(true);
        }
    }
}

