/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.StaffPlusPlusJoinedEvent;
import net.shortninja.staffplus.core.common.utils.BukkitUtils;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettings;
import net.shortninja.staffplus.core.domain.player.settings.PlayerSettingsRepository;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@IocBukkitListener
public class PlayerJoin
implements Listener {
    private final PlayerSettingsRepository playerSettingsRepository;
    private final OnlineSessionsManager sessionManager;
    private final PlayerManager playerManager;
    private final IProtocolService protocolService;
    private final BukkitUtils bukkitUtils;

    public PlayerJoin(PlayerSettingsRepository playerSettingsRepository, OnlineSessionsManager sessionManager, PlayerManager playerManager, IProtocolService protocolService, BukkitUtils bukkitUtils) {
        this.playerSettingsRepository = playerSettingsRepository;
        this.sessionManager = sessionManager;
        this.playerManager = playerManager;
        this.protocolService = protocolService;
        this.bukkitUtils = bukkitUtils;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent event) {
        this.protocolService.getVersionProtocol().inject(event.getPlayer());
        this.playerManager.syncPlayer(event.getPlayer());
        Player player = event.getPlayer();
        this.bukkitUtils.runTaskAsync(() -> {
            this.playerManager.storePlayer((OfflinePlayer)player);
            PlayerSettings playerSettings = this.playerSettingsRepository.get((OfflinePlayer)player);
            PlayerSession onlinePlayerSession = this.sessionManager.get(player);
            BukkitUtils.sendEvent(new StaffPlusPlusJoinedEvent(event, onlinePlayerSession, playerSettings));
        });
    }
}

