/*
 * Decompiled with CFR 0.152.
 */
package net.shortninja.staffplus.core.domain.player.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.shortninja.staffplus.core.application.session.OnlineSessionsManager;
import net.shortninja.staffplus.core.application.session.PlayerSession;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubingbukkit.annotations.IocBukkitListener;
import net.shortninja.staffplus.core.be.garagepoort.mcioc.tubinggui.GuiActionService;
import net.shortninja.staffplus.core.common.IProtocolService;
import net.shortninja.staffplus.core.common.JavaUtils;
import net.shortninja.staffplus.core.common.cmd.CommandUtil;
import net.shortninja.staffplus.core.domain.player.PlayerManager;
import net.shortninja.staffplus.core.domain.staff.chests.ChestGuiBuilder;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeHandler;
import net.shortninja.staffplus.core.domain.staff.freeze.FreezeRequest;
import net.shortninja.staffplus.core.domain.staff.mode.config.GeneralModeConfiguration;
import net.shortninja.staffplus.core.domain.staff.mode.custommodules.CustomModuleHandler;
import net.shortninja.staffplus.core.domain.staff.mode.handler.CpsHandler;
import net.shortninja.staffplus.core.domain.staff.mode.handler.GadgetHandler;
import net.shortninja.staffplus.core.domain.staff.mode.handler.GadgetType;
import net.shortninja.staffplusplus.session.SppPlayer;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

@IocBukkitListener
public class PlayerInteract
implements Listener {
    private static final int COOLDOWN = 200;
    private static final Map<Player, Long> staffTimings = new HashMap<Player, Long>();
    private final IProtocolService protocolService;
    private final CpsHandler cpsHandler;
    private final GadgetHandler gadgetHandler;
    private final FreezeHandler freezeHandler;
    private final PlayerManager playerManager;
    private final OnlineSessionsManager sessionManager;
    private final GuiActionService guiActionService;
    private final ChestGuiBuilder chestGuiBuilder;
    private final CommandUtil commandUtil;
    private final CustomModuleHandler customModuleHandler;

    public PlayerInteract(IProtocolService protocolService, CpsHandler cpsHandler, GadgetHandler gadgetHandler, FreezeHandler freezeHandler, PlayerManager playerManager, OnlineSessionsManager sessionManager, GuiActionService guiActionService, ChestGuiBuilder chestGuiBuilder, CommandUtil commandUtil, CustomModuleHandler customModuleHandler) {
        this.protocolService = protocolService;
        this.cpsHandler = cpsHandler;
        this.gadgetHandler = gadgetHandler;
        this.freezeHandler = freezeHandler;
        this.playerManager = playerManager;
        this.sessionManager = sessionManager;
        this.guiActionService = guiActionService;
        this.chestGuiBuilder = chestGuiBuilder;
        this.commandUtil = commandUtil;
        this.customModuleHandler = customModuleHandler;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInteract(PlayerInteractEvent event) {
        PlayerSession playerSession;
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Action action = event.getAction();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (this.cpsHandler.isTesting(uuid) && (action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK)) {
            this.cpsHandler.updateCount(uuid);
        }
        if (!(playerSession = this.sessionManager.get(player)).isInStaffMode() || item == null) {
            return;
        }
        GeneralModeConfiguration modeConfiguration = playerSession.getModeConfig().get();
        if (this.staffCheckingChest(event, player)) {
            if (modeConfiguration.isModeSilentChestInteraction() && !player.isSneaking()) {
                Container container = (Container)event.getClickedBlock().getState();
                this.chestGuiBuilder.build(container, modeConfiguration.isModeSilentChestInteraction()).show(player);
                event.setCancelled(true);
            }
            return;
        }
        if (!playerSession.getCurrentGui().isPresent() && this.handleInteraction(player, item, action)) {
            event.setCancelled(true);
        }
    }

    private boolean staffCheckingChest(PlayerInteractEvent event, Player player) {
        return event.getClickedBlock() != null && event.getClickedBlock().getState() instanceof Container && this.sessionManager.get(player).isInStaffMode();
    }

    private boolean handleInteraction(Player player, ItemStack item, Action action) {
        boolean isHandled = true;
        if (action == Action.PHYSICAL) {
            return false;
        }
        GadgetType gadgetType = this.gadgetHandler.getGadgetType(this.protocolService.getVersionProtocol().getNbtString(item));
        if (staffTimings.containsKey(player) && System.currentTimeMillis() - staffTimings.get(player) <= 200L) {
            return gadgetType != GadgetType.CUSTOM;
        }
        switch (gadgetType) {
            case COMPASS: {
                this.gadgetHandler.onCompass(player);
                break;
            }
            case RANDOM_TELEPORT: {
                this.gadgetHandler.onRandomTeleport(player);
                break;
            }
            case VANISH: {
                this.gadgetHandler.onVanish(player);
                break;
            }
            case GUI_HUB: {
                this.gadgetHandler.onGuiHub(player);
                break;
            }
            case COUNTER: {
                this.gadgetHandler.onCounter(player);
                break;
            }
            case FREEZE: {
                this.commandUtil.playerAction(player, () -> {
                    Player targetPlayer = JavaUtils.getTargetPlayer(player);
                    if (targetPlayer != null) {
                        PlayerSession session = this.sessionManager.get(targetPlayer);
                        this.freezeHandler.execute(new FreezeRequest((CommandSender)player, targetPlayer, !session.isFrozen()));
                    }
                });
                break;
            }
            case CPS: {
                this.gadgetHandler.onCps((CommandSender)player, JavaUtils.getTargetPlayer(player));
                break;
            }
            case EXAMINE: {
                Player targetPlayer = JavaUtils.getTargetPlayer(player);
                if (targetPlayer == null) break;
                Optional<SppPlayer> onlinePlayer = this.playerManager.getOnlinePlayer(targetPlayer.getUniqueId());
                this.gadgetHandler.onExamine(player, onlinePlayer.get());
                break;
            }
            case FOLLOW: {
                this.gadgetHandler.onFollow(player, JavaUtils.getTargetPlayer(player));
                break;
            }
            case PLAYER_DETAILS: {
                this.commandUtil.playerAction(player, () -> {
                    Player t = JavaUtils.getTargetPlayer(player);
                    if (t != null) {
                        this.guiActionService.executeAction(player, "players/view/detail?targetPlayerName=" + t.getName());
                    }
                });
                break;
            }
            case CUSTOM: {
                isHandled = this.customModuleHandler.handleCustomModule(player, item);
                break;
            }
        }
        staffTimings.put(player, System.currentTimeMillis());
        return isHandled;
    }
}

